import {getType} from 'typesafe-actions';
import {CommonAction} from 'redux/reducers/actions';
import {
    orderRequest,
    orderRequestSuccess,
    orderRequestFailure,
    resetOrder,
    orderLogsRequest,
    orderLogsRequestSuccess,
    orderLogsRequestFailure,
    resetOrderLogs,
    orderWorkflowRequest,
    orderWorkflowRequestSuccess,
    orderWorkflowRequestFailure,
    resetOrderWorkflow,
    orderPayloadsRequest,
    orderPayloadsRequestSuccess,
    orderPayloadsRequestFailure,
    resetOrderPayloads,
    orderEditPayloadRequest,
    orderEditPayloadRequestSuccess,
    orderEditPayloadRequestFailure,
    orderEditEmailRequest,
    orderEditEmailRequestSuccess,
    orderEditEmailRequestFailure,
    resetOrderEditEmail,
    orderEditPhoneRequest,
    orderEditPhoneRequestSuccess,
    orderEditPhoneRequestFailure,
    resetOrderEditPhone,
    orderSendNotificationRequest,
    orderSendNotificationRequestSuccess,
    orderSendNotificationRequestFailure,
    resetOrderSendNotification,
    orderRetryMoneyRefundRequest,
    orderRetryMoneyRefundRequestSuccess,
    orderRetryMoneyRefundRequestFailure,
    resetOrderRetryMoneyRefund,
    orderUpdateTrainTicketsRequest,
    orderUpdateTrainTicketsRequestSuccess,
    orderUpdateTrainTicketsRequestFailure,
    orderUpdateTrainTicketsRequestTimeout,
    resetOrderUpdateTrainTickets,
    orderRefundRequest,
    orderRefundRequestSuccess,
    orderRefundRequestFailure,
    orderRefundRequestTimeout,
    resetOrderRefund,
    orderStartrekTicketsRequest,
    orderStartrekTicketsRequestSuccess,
    orderStartrekTicketsRequestFailure,
    resetOrderStartrekTickets,
    restoreDolphinOrderRequest,
    restoreDolphinOrderRequestSuccess,
    restoreDolphinOrderRequestFailure,
    regenerateVouchersRequest,
    regenerateVouchersRequestSuccess,
    regenerateVouchersRequestFailure,
    refundHotelOrderRequest,
    refundHotelOrderRequestSuccess,
    refundHotelOrderRequestFailure,
    calculateHotelOrderRefundRequest,
    calculateHotelOrderRefundRequestSuccess,
    calculateHotelOrderRefundRequestFailure,
    calculateHotelMoneyOnlyRefundRequest,
    calculateHotelMoneyOnlyRefundRequestSuccess,
    calculateHotelMoneyOnlyRefundRequestFailure,
    refundHotelMoneyOnlyRequest,
    refundHotelMoneyOnlyRequestSuccess,
    refundHotelMoneyOnlyRequestFailure,
    modifyHotelOrderDetailsRequest,
    modifyHotelOrderDetailsRequestSuccess,
    modifyHotelOrderDetailsRequestFailure,
} from 'redux/reducers/order/actions';

import {IStoreOrder} from 'redux/reducers/types';

const initialState: IStoreOrder = {
    item: {
        value: null,
        isLoading: false,
        isFetched: false,
        error: null,
    },
    logs: {
        value: [],
        overallItemsCount: 0,
        isLoading: false,
        isFetched: false,
        error: null,
    },
    workflow: {
        value: null,
        isLoading: false,
        isFetched: false,
        error: null,
    },
    payloads: {
        items: {
            value: null,
            isLoading: false,
            isFetched: false,
            error: null,
        },
        edit: {
            isSuccess: true,
            isLoading: false,
            isFetched: false,
            error: null,
        },
    },
    emailEdition: {
        isLoading: false,
        isFetched: false,
        error: null,
    },
    phoneEdition: {
        isLoading: false,
        isFetched: false,
        error: null,
    },
    sendingNotification: {
        isLoading: false,
        isFetched: false,
        error: null,
    },
    retryingMoneyRefund: {
        isLoading: false,
        isFetched: false,
        error: null,
    },
    updatingTrainTickets: {
        isLoading: false,
        isFetched: false,
        error: null,
    },
    refund: {
        isLoading: false,
        isFetched: false,
        error: null,
    },
    startrekTickets: {
        value: null,
        isLoading: false,
        isFetched: false,
        error: null,
    },
    vouchers: {
        value: null,
    },
    restoreDolphinOrder: {
        isLoading: false,
        isFetched: false,
        error: null,
    },
    regenerateVouchers: {
        isLoading: false,
        isFetched: false,
        error: null,
    },
    calculateHotelOrderRefund: {
        isLoading: false,
        isFetched: false,
        error: null,
        calculatedRefund: null,
    },
    refundHotelOrder: {
        isLoading: false,
        isFetched: false,
        error: null,
    },
    calculateHotelMoneyOnlyRefund: {
        isLoading: false,
        isFetched: false,
        error: null,
        calculatedRefund: null,
    },
    refundHotelMoneyOnly: {
        isLoading: false,
        isFetched: false,
        error: null,
    },
    modifyHotelOrderDetails: {
        isLoading: false,
        isFetched: false,
        error: null,
    },
};

export default (
    state: IStoreOrder = initialState,
    action: CommonAction,
): IStoreOrder => {
    switch (action.type) {
        case getType(orderRequest):
            return {
                ...state,
                item: {
                    ...state.item,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(orderRequestSuccess):
            return {
                ...state,
                item: {
                    ...state.item,
                    isLoading: false,
                    isFetched: true,
                    value: action.payload,
                    error: null,
                },
            };

        case getType(orderRequestFailure):
            return {
                ...state,
                item: {
                    ...state.item,
                    isLoading: false,
                    isFetched: true,
                    value: null,
                    error: action.payload,
                },
            };

        case getType(resetOrder):
            return {
                ...state,
                item: initialState.item,
            };

        case getType(orderLogsRequest):
            return {
                ...state,
                logs: {
                    ...state.logs,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(orderLogsRequestSuccess):
            return {
                ...state,
                logs: {
                    ...state.logs,
                    value: action.payload.records,
                    overallItemsCount: action.payload.count,
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(orderLogsRequestFailure):
            return {
                ...state,
                logs: {
                    ...state.logs,
                    isLoading: false,
                    isFetched: true,
                    value: [],
                    error: action.payload,
                },
            };

        case getType(resetOrderLogs):
            return {
                ...state,
                logs: initialState.logs,
            };

        case getType(orderWorkflowRequest):
            return {
                ...state,
                workflow: {
                    ...state.logs,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(orderWorkflowRequestSuccess):
            return {
                ...state,
                workflow: {
                    ...state.logs,
                    value: action.payload,
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(orderWorkflowRequestFailure):
            return {
                ...state,
                workflow: {
                    ...state.logs,
                    value: null,
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(resetOrderWorkflow):
            return {
                ...state,
                workflow: initialState.workflow,
            };

        case getType(orderPayloadsRequest):
            return {
                ...state,
                payloads: {
                    ...state.payloads,
                    items: {
                        ...state.payloads.items,
                        isLoading: true,
                        isFetched: false,
                        error: null,
                    },
                },
            };

        case getType(orderPayloadsRequestSuccess):
            return {
                ...state,
                payloads: {
                    ...state.payloads,
                    items: {
                        ...state.payloads.items,
                        value: action.payload,
                        isLoading: false,
                        isFetched: true,
                        error: null,
                    },
                },
            };

        case getType(orderPayloadsRequestFailure):
            return {
                ...state,
                payloads: {
                    ...state.payloads,
                    items: {
                        ...state.payloads.items,
                        value: null,
                        isLoading: false,
                        isFetched: true,
                        error: action.payload,
                    },
                },
            };

        case getType(resetOrderPayloads):
            return {
                ...state,
                payloads: initialState.payloads,
            };

        case getType(orderEditPayloadRequest):
            return {
                ...state,
                payloads: {
                    ...state.payloads,
                    edit: {
                        ...state.payloads.edit,
                        isLoading: true,
                        isFetched: false,
                        error: null,
                    },
                },
            };

        case getType(orderEditPayloadRequestSuccess):
            return {
                ...state,
                payloads: {
                    ...state.payloads,
                    edit: {
                        ...state.payloads.edit,
                        isSuccess: true,
                        isLoading: false,
                        isFetched: true,
                        error: null,
                    },
                },
            };

        case getType(orderEditPayloadRequestFailure):
            return {
                ...state,
                payloads: {
                    ...state.payloads,
                    edit: {
                        ...state.payloads.edit,
                        isSuccess: false,
                        isLoading: false,
                        isFetched: true,
                        error: action.payload,
                    },
                },
            };

        case getType(orderEditEmailRequest):
            return {
                ...state,
                emailEdition: {
                    ...state.emailEdition,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(orderEditEmailRequestSuccess):
            return {
                ...state,
                emailEdition: {
                    ...state.emailEdition,
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(orderEditEmailRequestFailure):
            return {
                ...state,
                emailEdition: {
                    ...state.emailEdition,
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(resetOrderEditEmail):
            return {
                ...state,
                emailEdition: initialState.emailEdition,
            };

        case getType(orderEditPhoneRequest):
            return {
                ...state,
                phoneEdition: {
                    ...state.phoneEdition,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(orderEditPhoneRequestSuccess):
            return {
                ...state,
                phoneEdition: {
                    ...state.phoneEdition,
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(orderEditPhoneRequestFailure):
            return {
                ...state,
                phoneEdition: {
                    ...state.phoneEdition,
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(resetOrderEditPhone):
            return {
                ...state,
                phoneEdition: initialState.phoneEdition,
            };

        case getType(orderSendNotificationRequest):
            return {
                ...state,
                sendingNotification: {
                    ...state.sendingNotification,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(orderSendNotificationRequestSuccess):
            return {
                ...state,
                sendingNotification: {
                    ...state.sendingNotification,
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(orderSendNotificationRequestFailure):
            return {
                ...state,
                sendingNotification: {
                    ...state.sendingNotification,
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(resetOrderSendNotification):
            return {
                ...state,
                sendingNotification: initialState.sendingNotification,
            };

        case getType(orderRetryMoneyRefundRequest):
            return {
                ...state,
                retryingMoneyRefund: {
                    ...state.retryingMoneyRefund,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(orderRetryMoneyRefundRequestSuccess):
            return {
                ...state,
                retryingMoneyRefund: {
                    ...state.retryingMoneyRefund,
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(orderRetryMoneyRefundRequestFailure):
            return {
                ...state,
                retryingMoneyRefund: {
                    ...state.retryingMoneyRefund,
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(resetOrderRetryMoneyRefund):
            return {
                ...state,
                retryingMoneyRefund: initialState.retryingMoneyRefund,
            };

        case getType(orderUpdateTrainTicketsRequest):
            return {
                ...state,
                updatingTrainTickets: {
                    ...state.updatingTrainTickets,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(orderUpdateTrainTicketsRequestSuccess):
            return {
                ...state,
                updatingTrainTickets: {
                    ...state.updatingTrainTickets,
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(orderUpdateTrainTicketsRequestFailure):
            return {
                ...state,
                updatingTrainTickets: {
                    ...state.updatingTrainTickets,
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(orderUpdateTrainTicketsRequestTimeout):
            return {
                ...state,
                updatingTrainTickets: {
                    ...state.updatingTrainTickets,
                    isLoading: false,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(resetOrderUpdateTrainTickets):
            return {
                ...state,
                updatingTrainTickets: initialState.updatingTrainTickets,
            };

        case getType(orderRefundRequest):
            return {
                ...state,
                refund: {
                    ...state.refund,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(orderRefundRequestSuccess):
            return {
                ...state,
                refund: {
                    ...state.refund,
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(orderRefundRequestFailure):
            return {
                ...state,
                refund: {
                    ...state.refund,
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(orderRefundRequestTimeout):
            return {
                ...state,
                refund: {
                    ...state.refund,
                    isLoading: false,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(resetOrderRefund):
            return {
                ...state,
                refund: initialState.refund,
            };

        case getType(orderStartrekTicketsRequest):
            return {
                ...state,
                startrekTickets: {
                    ...state.startrekTickets,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(orderStartrekTicketsRequestSuccess):
            return {
                ...state,
                startrekTickets: {
                    ...state.startrekTickets,
                    value: action.payload,
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(orderStartrekTicketsRequestFailure):
            return {
                ...state,
                startrekTickets: {
                    ...state.startrekTickets,
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(resetOrderStartrekTickets):
            return {
                ...state,
                startrekTickets: initialState.startrekTickets,
            };

        case getType(restoreDolphinOrderRequest):
            return {
                ...state,
                restoreDolphinOrder: {
                    ...state.restoreDolphinOrder,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(restoreDolphinOrderRequestSuccess):
            return {
                ...state,
                restoreDolphinOrder: {
                    ...state.restoreDolphinOrder,
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(restoreDolphinOrderRequestFailure):
            return {
                ...state,
                restoreDolphinOrder: {
                    ...state.restoreDolphinOrder,
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(regenerateVouchersRequest):
            return {
                ...state,
                regenerateVouchers: {
                    ...state.regenerateVouchers,
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(regenerateVouchersRequestSuccess):
            return {
                ...state,
                regenerateVouchers: {
                    ...state.regenerateVouchers,
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(regenerateVouchersRequestFailure):
            return {
                ...state,
                regenerateVouchers: {
                    ...state.regenerateVouchers,
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(refundHotelOrderRequest):
            return {
                ...state,
                refundHotelOrder: {
                    isLoading: true,
                    isFetched: false,
                    error: state.refundHotelOrder.error,
                },
            };

        case getType(refundHotelOrderRequestSuccess):
            return {
                ...state,
                refundHotelOrder: {
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(refundHotelOrderRequestFailure):
            return {
                ...state,
                refundHotelOrder: {
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(calculateHotelOrderRefundRequest):
            return {
                ...state,
                calculateHotelOrderRefund: {
                    isLoading: true,
                    isFetched: false,
                    error: null,
                    calculatedRefund: null,
                },
            };

        case getType(calculateHotelOrderRefundRequestSuccess):
            return {
                ...state,
                calculateHotelOrderRefund: {
                    isLoading: false,
                    isFetched: true,
                    error: null,
                    calculatedRefund: action.payload,
                },
            };

        case getType(calculateHotelOrderRefundRequestFailure):
            return {
                ...state,
                calculateHotelOrderRefund: {
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                    calculatedRefund: null,
                },
            };

        case getType(calculateHotelMoneyOnlyRefundRequest):
            return {
                ...state,
                calculateHotelMoneyOnlyRefund: {
                    isLoading: true,
                    isFetched: false,
                    error: null,
                    calculatedRefund: null,
                },
            };

        case getType(calculateHotelMoneyOnlyRefundRequestSuccess):
            return {
                ...state,
                calculateHotelMoneyOnlyRefund: {
                    isLoading: false,
                    isFetched: true,
                    error: null,
                    calculatedRefund: action.payload,
                },
            };

        case getType(calculateHotelMoneyOnlyRefundRequestFailure):
            return {
                ...state,
                calculateHotelMoneyOnlyRefund: {
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                    calculatedRefund: null,
                },
            };

        case getType(refundHotelMoneyOnlyRequest):
            return {
                ...state,
                refundHotelMoneyOnly: {
                    isLoading: true,
                    isFetched: false,
                    error: state.refundHotelMoneyOnly.error,
                },
            };

        case getType(refundHotelMoneyOnlyRequestSuccess):
            return {
                ...state,
                refundHotelMoneyOnly: {
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(refundHotelMoneyOnlyRequestFailure):
            return {
                ...state,
                refundHotelMoneyOnly: {
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        case getType(modifyHotelOrderDetailsRequest):
            return {
                ...state,
                modifyHotelOrderDetails: {
                    isLoading: true,
                    isFetched: false,
                    error: null,
                },
            };

        case getType(modifyHotelOrderDetailsRequestSuccess):
            return {
                ...state,
                modifyHotelOrderDetails: {
                    isLoading: false,
                    isFetched: true,
                    error: null,
                },
            };

        case getType(modifyHotelOrderDetailsRequestFailure):
            return {
                ...state,
                modifyHotelOrderDetails: {
                    isLoading: false,
                    isFetched: true,
                    error: action.payload,
                },
            };

        default:
            return state;
    }
};
