import {createAction, createAsyncAction} from 'typesafe-actions';

import {
    DisplayOrderType,
    IBriefOrderInfo,
    IFetchError,
    OrderCarrier,
    OrderPartner,
    OrderReferralPartnerId,
    OrderStatus,
    PaymentScheduleType,
} from 'redux/reducers/types';

export interface IFetchOrderParams {
    page?: number;
    count?: number;
    partnerId?: string;
    prettyId?: string;
    email?: string;
    phone?: string;
    name?: string;
    card?: string;
    token?: string;
    status?: OrderStatus;
    partner?: OrderPartner;
    displayType?: DisplayOrderType;
    fromDate?: string;
    toDate?: string;
    isBroken?: boolean | string;
    sortType?: string;
    paymentScheduleType?: PaymentScheduleType;
    ticketNumber?: string;
    yandexUid?: string;
    carrier?: OrderCarrier;
    referralPartnerId?: OrderReferralPartnerId;
}

const {
    request: ordersRequest,
    success: ordersRequestSuccess,
    failure: ordersRequestFailure,
} = createAsyncAction(
    'ORDERS.FETCH_ORDERS',
    'ORDERS.SET_ORDERS_FETCH_SUCCESS',
    'ORDERS.SET_ORDERS_FETCH_FAILURE',
)<
    IFetchOrderParams,
    {
        orders: IBriefOrderInfo[];
        overallItemsCount: number;
    },
    IFetchError
>();

const {
    request: ordersSearchFormOptionsRequest,
    success: ordersSearchFormOptionsRequestSuccess,
    failure: ordersSearchFormOptionsRequestFailure,
} = createAsyncAction(
    'ORDERS.FETCH_ORDERS_SEARCH_FORM_OPTIONS',
    'ORDERS.SET_ORDERS_SEARCH_FORM_OPTIONS_FETCH_SUCCESS',
    'ORDERS.SET_ORDERS_SEARCH_FORM_OPTIONS_FETCH_FAILURE',
)<
    IFetchOrderParams,
    {
        stateOptions: OrderStatus[];
        displayTypeOptions: DisplayOrderType[];
        partnerOptions: OrderPartner[];
    },
    IFetchError
>();

export const resetOrders = createAction('ORDERS.RESET')();

export {
    ordersRequest,
    ordersRequestSuccess,
    ordersRequestFailure,
    ordersSearchFormOptionsRequest,
    ordersSearchFormOptionsRequestSuccess,
    ordersSearchFormOptionsRequestFailure,
};
