import {getType} from 'typesafe-actions';
import {CommonAction} from 'redux/reducers/actions';
import {
    ordersRequest,
    ordersRequestSuccess,
    ordersRequestFailure,
    resetOrders,
    ordersSearchFormOptionsRequest,
    ordersSearchFormOptionsRequestSuccess,
    ordersSearchFormOptionsRequestFailure,
} from 'redux/reducers/orders/actions';

import {IStoreOrders} from 'redux/reducers/types';

const initialState: IStoreOrders = {
    isLoading: false,
    isFetched: false,
    value: [],
    error: null,
    overallItemsCount: 0,

    isOptionsLoading: false,
    isOptionsFetched: false,
    optionsError: null,
    stateOptions: [],
    displayTypeOptions: [],
    partnerOptions: [],
};

export default (
    state: IStoreOrders = initialState,
    action: CommonAction,
): IStoreOrders => {
    switch (action.type) {
        case getType(ordersRequest):
            return {
                ...state,
                isLoading: true,
                isFetched: false,
                error: null,
            };

        case getType(ordersRequestSuccess):
            return {
                ...state,
                isLoading: false,
                isFetched: true,
                value: action.payload.orders,
                overallItemsCount: action.payload.overallItemsCount,
                error: null,
            };

        case getType(ordersRequestFailure):
            return {
                ...state,
                isLoading: false,
                isFetched: true,
                value: [],
                overallItemsCount: 0,
                error: action.payload,
            };

        case getType(ordersSearchFormOptionsRequest):
            return {
                ...state,
                isOptionsLoading: true,
                isOptionsFetched: false,
                optionsError: null,
            };

        case getType(ordersSearchFormOptionsRequestSuccess):
            return {
                ...state,
                isOptionsLoading: false,
                isOptionsFetched: true,
                stateOptions: action.payload.stateOptions,
                displayTypeOptions: action.payload.displayTypeOptions,
                partnerOptions: action.payload.partnerOptions,
                optionsError: null,
            };

        case getType(ordersSearchFormOptionsRequestFailure):
            return {
                ...state,
                isOptionsLoading: false,
                isOptionsFetched: true,
                stateOptions: [],
                displayTypeOptions: [],
                partnerOptions: [],
                optionsError: action.payload,
            };

        case getType(resetOrders):
            return {
                ...initialState,
                isOptionsLoading: state.isOptionsLoading,
                isOptionsFetched: state.isOptionsFetched,
                stateOptions: state.stateOptions,
                displayTypeOptions: state.displayTypeOptions,
                partnerOptions: state.partnerOptions,
            };

        default:
            return state;
    }
};
