import {getType} from 'typesafe-actions';
import {CommonAction} from 'redux/reducers/actions';
import {setIsSettingsTechTexts} from 'redux/reducers/settings/actions';

import {IStoreSettings} from 'redux/reducers/types';

function getIsTechTextsStoredOption(): boolean {
    try {
        const isTechTexts = JSON.parse(
            localStorage.getItem('travelOrdersAdmin.settings.isTechTexts') ||
                '',
        );

        return typeof isTechTexts === 'boolean' ? isTechTexts : false;
    } catch (err) {
        return false;
    }
}

const initialState: IStoreSettings = {
    isTechTexts: getIsTechTextsStoredOption(),
};

export default (
    state: IStoreSettings = initialState,
    action: CommonAction,
): IStoreSettings => {
    switch (action.type) {
        case getType(setIsSettingsTechTexts):
            return {
                ...state,
                isTechTexts: action.payload,
            };

        default:
            return state;
    }
};
