import {IPrice} from 'redux/reducers/types/index';

export interface IBriefAviaSegment {
    departure_date_time: string;
    direction: string;
    flight_number: string;
}

export interface IBriefAviaInfo {
    segments: IBriefAviaSegment[];
}

export interface IAviaOrderPassenger {
    first_name: string;
    middle_name: string | null;
    last_name: string;
    nationality: string;
    document_type: string;
    document_number: number;
    date_of_birth: string;
}

export interface IAviaOrderSegment {
    flight_number: number;
    aircraft_code: string;
    departure_airport: string;
    arrival_airport: string;
    departure_at: string;
    arrival_at: string;
}

export interface IAviaOrderFlightLeg {
    segments: IAviaOrderSegment[];
}

export interface IAviaOrderItem {
    passengers: IAviaOrderPassenger[] | null;
    pnr: string;
    legs: IAviaOrderFlightLeg[];
    total_price: IPrice;
}
