import {IPrice} from 'redux/reducers/types/index';

export interface IBriefBusPassenger {
    seat_id: string | null;
}

export interface IBriefBusInfo {
    route_name: string;
    departure: string | null;
    arrival: string | null;
    departure_time_zone: string | null;
    arrival_time_zone: string | null;
    passengers: IBriefBusPassenger[];
}

export enum BusDocumentType {
    RU_PASSPORT = 'RU_PASSPORT',
    RU_BIRTH_CERTIFICATE = 'RU_BIRTH_CERTIFICATE',
    RU_INTERNATIONAL_PASSPORT = 'RU_INTERNATIONAL_PASSPORT',
    RU_FOREIGN_PASSPORT = 'RU_FOREIGN_PASSPORT',
    BY_PASSPORT = 'BY_PASSPORT',
}

export enum BusTicketType {
    FULL = 'FULL',
    CHILD = 'CHILD',
    BAGGAGE = 'BAGGAGE',
}

export interface IBusPassenger {
    first_name: string;
    middle_name: string;
    last_name: string;
    birthday: string;
    document_type: BusDocumentType;
    document_number: string;
    ticket_type: BusTicketType;
    seat_id: string | null;
    blank_url: string;
}

export interface IBusRide {
    ride_id: string;
    departure_time: string | null;
    departure_time_zone: string | null;
    arrival_time: string | null;
    arrival_time_zone: string | null;
    duration: number | null;
    price: IPrice;
    fee: IPrice;
    yandex_fee: IPrice;
    free_seats: number;
    route_name: string;
    refund_conditions: string;
}

export interface IBusOrderItem {
    offer_id: string;
    passengers: IBusPassenger[];
    ride: IBusRide;
}
