import {IPrice} from 'redux/reducers/types/index';

export interface IBriefHotelInfo {
    arrive_date: string;
    check_out_date: string;
    city: string;
    hotel_name: string;
}

export interface IHotelOrderGuest {
    first_name: string;
    last_name: string;
    age?: number;
    child: boolean;
}

export enum IHotelPenaltyTypes {
    NO_PENALTY = 'NO_PENALTY',
    SOME_PENALTY = 'SOME_PENALTY',
    FULL_PRICE = 'FULL_PRICE',
}

export interface IHotelOrderCancellationPenaltyItem {
    starts_at: string | null;
    ends_at: string | null;
    type: IHotelPenaltyTypes;
    amount: number | null;
    currency: number | null;
}

export interface IHotelOrderCancellationInfo {
    refundable: boolean;
    penalties: IHotelOrderCancellationPenaltyItem[];
    highlighted: boolean;
}

export interface IHotelOrderAmenity {
    id: string;
    name: string;
}

export interface ILocalizedPansionInfo {
    pansion_type: string;
    name: string;
}

export interface IBedGroup {
    description: string;
}

export interface IOrderRoomInfo {
    amenities: IHotelOrderAmenity[];
    pansion_info: ILocalizedPansionInfo;
    bed_groups: IBedGroup[];
}

export interface IHotelOrderItem {
    itinerary_id: string | null;
    price_info: IPrice;
    basic_hotel_info: {
        name: string;
        phone: string;
        address: string;
        permalink: number;
        provider_id: string;
        original_id: string | null;
        legal_info: any;
        location_type: any;
        altay_permaling_url: string;
        altay_signals_url: string | null;
    };
    request_info: {
        checkin_date: string;
        checkout_date: string;
    };
    cancellation_info: IHotelOrderCancellationInfo;
    confirmation_info: {
        confirmed_at: string | null;
        confirmation_id: number;
        document_url: string;
    };
    refund_info: {
        refund_date_time: string;
    } | null;
    guest_info: {
        customer_email: string;
        customer_phone: number;
        allows_subscription: boolean;
        guests: IHotelOrderGuest[];
    } | null;
    room_info: IOrderRoomInfo;
}
