import {IPrice} from 'redux/reducers/types/index';

export interface ITrainOrderPassengerInsurance {
    amount: IPrice;
    company: string;
    partner_operation_id: null;
    partner_operation_status: string | null;
}

export enum TrainOrderPassengerTicketBlankStatus {
    ELECTRONIC_REGISTRATION_ABSENT = 'ElectronicRegistrationAbsent',
    ELECTRONIC_REGISTRATION_PRESENT = 'ElectronicRegistrationPresent',
    NOT_CONFIRMED = 'NotConfirmed',
    VOIDED = 'Voided',
    RETURNED = 'Returned',
    PLACES_RETURNED = 'PlacesReturned',
    VOUCHER_ISSUED = 'VoucherIssued',
    TRIP_WAS_INTERRUPTED = 'TripWasInterrupted',
    TRIP_WAS_INTERRUPTED_AND_RESUME_AFTER = 'TripWasInterruptedAndResumedAfter',
    UNKNOWN = 'Unknown',
}

export interface ITrainOrderPassengerTicket {
    blank_id: number;
    im_blank_status: TrainOrderPassengerTicketBlankStatus | null;
    pending_electronic_registration: boolean;
    places: {
        number: string;
        type: string;
    }[];

    /**
     * Общая стоимость билета (включая все сборы)
     */
    total_cost: IPrice;

    /**
     * Основная стоимость билета
     */
    tariff_amount: IPrice;

    /**
     * Сервисные и прочие сборы (например, стоимость белья)
     */
    service_amount: IPrice;

    /**
     * Сбор Яндекса
     */
    fee_amount: IPrice;

    /**
     * Сумма, которая будет возвращена пользователю при возврате
     */
    refund_fee_amount: IPrice;

    refund_status: null;
}

export enum TrainOrderDocumentType {
    RUSSIAN_PASSPORT = 'RussianPassport',
    BIRTH_CERTIFICATE = 'BirthCertificate',
    RUSSIAN_INTERNATIONAL_PASSPORT = 'RussianForeignPassport',
    FOREIGN_DOCUMENT = 'ForeignPassport',
    SAILOR_PASSPORT = 'SailorPassport',
    MILITARY_CARD = 'MilitaryCard',
}

export enum TrainOrderPassengerCategoryType {
    ADULT = 'Adult',
    CHILD = 'Child',
    BABY = 'BabyWithoutPlace',
}

export interface ITrainOrderPassenger {
    birthday: null | string;
    booked_tariff_type: string;
    category: TrainOrderPassengerCategoryType;
    citizenship_code: string;
    customer_id: number;
    document_number: null;
    document_type: TrainOrderDocumentType;
    first_name: null;
    insurance: ITrainOrderPassengerInsurance | null;
    last_name: null;
    patronymic: null;
    sex: string;
    tariff_type: string;
    ticket: ITrainOrderPassengerTicket | null;
}

export interface ITrainOrderItem {
    arrival_at: string;
    arrival_station: string;
    car_number: string;
    carrier: string;
    departure_at: string;
    departure_station: string;
    direction: string;
    eregister_status_till: string | null;
    order_insurance_status: string;
    order_item_state: string;
    partner_number: string;
    passengers_info: ITrainOrderPassenger[];
    refund_till: string | null;
    train_number: string;
}

export interface IBriefTrainsPassenger {
    age: number;
    fio: string;
    place_numbers?: string[];
}

export interface IBriefTrainsInfo {
    arrival_station: string;
    car_number: string;
    departure_date_time: string;
    departure_station: string;
    passengers: IBriefTrainsPassenger[];
    train_number: string;
}
