import {getType} from 'typesafe-actions';
import {CommonAction} from 'redux/reducers/actions';
import {setUserInfoAccess} from 'redux/reducers/userInfo/actions';

import {IStoreUserInfo} from 'redux/reducers/types';

const initialState: IStoreUserInfo = {
    hasAccess: true,
};

export default (
    state: IStoreUserInfo = initialState,
    action: CommonAction,
): IStoreUserInfo => {
    switch (action.type) {
        case getType(setUserInfoAccess): {
            return {
                ...state,
                hasAccess: action.payload,
            };
        }

        default:
            return state;
    }
};
