import {getType, ActionType} from 'typesafe-actions';
import {takeEvery, put} from 'redux-saga/effects';
import {
    orderEditPayloadRequestFailure,
    orderLogsRequestFailure,
    orderPayloadsRequestFailure,
    orderRequestFailure,
    orderWorkflowRequestFailure,
    orderEditEmailRequestFailure,
    orderEditPhoneRequestFailure,
    orderSendNotificationRequestFailure,
    orderRetryMoneyRefundRequestFailure,
    orderUpdateTrainTicketsRequestFailure,
} from 'redux/reducers/order/actions';
import {
    ordersRequestFailure,
    ordersSearchFormOptionsRequestFailure,
} from 'redux/reducers/orders/actions';
import {setUserInfoAccess} from 'redux/reducers/userInfo/actions';

const fetchFailureActions = {
    orderRequestFailure,
    orderLogsRequestFailure,
    orderWorkflowRequestFailure,
    ordersRequestFailure,
    orderPayloadsRequestFailure,
    orderEditPayloadRequestFailure,
    ordersSearchFormOptionsRequestFailure,
    orderEditEmailRequestFailure,
    orderEditPhoneRequestFailure,
    orderSendNotificationRequestFailure,
    orderRetryMoneyRefundRequestFailure,
    orderUpdateTrainTicketsRequestFailure,
};

function* requestErrorsHandler({
    payload,
}: ActionType<typeof fetchFailureActions>) {
    if (payload.status === 403) {
        yield put(setUserInfoAccess(false));
    }
}

export default function* watchRequestsErrors() {
    yield takeEvery(
        Object.values(fetchFailureActions).map(getType),
        requestErrorsHandler,
    );
}
