import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IRefundHotelOrderRequestParams,
    refundHotelOrderRequest,
    refundHotelMoneyOnlyRequestSuccess,
    refundHotelMoneyOnlyRequestFailure,
    refundHotelMoneyOnlyRequest,
} from 'redux/reducers/order/actions';

import isAxiosError from 'lib/isAxiosError';

function requestRefundHotelMoneyOnly(
    data: Omit<IRefundHotelOrderRequestParams, 'addToast'>,
): Promise<AxiosResponse> {
    return apiClient.post(
        `/api/orders/${data.orderId}/refundHotelMoneyOnly`,
        data,
    );
}

function* handleFetch(action: ActionType<typeof refundHotelOrderRequest>) {
    const {
        payload: {addToast, ...callParams},
    } = action;

    try {
        yield call(requestRefundHotelMoneyOnly, callParams);

        yield put(refundHotelMoneyOnlyRequestSuccess());

        addToast('Возврат денежных средств запущен', {
            appearance: 'success',
            autoDismiss: true,
        });
    } catch (error) {
        addToast('Ошибка при возврате денежных средств', {
            appearance: 'error',
            autoDismiss: true,
        });

        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(refundHotelMoneyOnlyRequestFailure(error.response.data));
        }
    }
}

export default function* calculateHotelMoneyOnlyRefund() {
    yield takeLatest(getType(refundHotelMoneyOnlyRequest), handleFetch);
}
