import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IModifyHotelOrderDetailsRequestParams,
    modifyHotelOrderDetailsRequest,
    modifyHotelOrderDetailsRequestSuccess,
    modifyHotelOrderDetailsRequestFailure,
} from 'redux/reducers/order/actions';

import isAxiosError from 'lib/isAxiosError';

function requestModifyHotelOrderDetails(
    data: Omit<IModifyHotelOrderDetailsRequestParams, 'addToast'>,
): Promise<AxiosResponse> {
    return apiClient.post(
        `/api/orders/${data.orderId}/modifyHotelOrderDetails`,
        data,
    );
}

function* handleFetch(
    action: ActionType<typeof modifyHotelOrderDetailsRequest>,
) {
    const {
        payload: {addToast, ...callParams},
    } = action;

    try {
        yield call(requestModifyHotelOrderDetails, callParams);

        yield put(modifyHotelOrderDetailsRequestSuccess());

        addToast('Данные заказа успешно обновлены', {
            appearance: 'success',
            autoDismiss: true,
        });
    } catch (error) {
        addToast('Ошибка при обновлении заказа', {
            appearance: 'error',
            autoDismiss: true,
        });

        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(
                modifyHotelOrderDetailsRequestFailure(error.response.data),
            );
        }
    }
}

export default function* modifyHotelOrderDetails() {
    yield takeLatest(getType(modifyHotelOrderDetailsRequest), handleFetch);
}
