import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IRefundHotelOrderRequestParams,
    refundHotelOrderRequest,
    refundHotelOrderRequestSuccess,
    refundHotelOrderRequestFailure,
} from 'redux/reducers/order/actions';

import isAxiosError from 'lib/isAxiosError';

function requestRefundHotelOrder(
    data: Omit<IRefundHotelOrderRequestParams, 'addToast'>,
): Promise<AxiosResponse> {
    return apiClient.post(`/api/orders/${data.orderId}/refundHotelOrder`, data);
}

function* handleFetch(action: ActionType<typeof refundHotelOrderRequest>) {
    const {
        payload: {addToast, ...callParams},
    } = action;

    try {
        yield call(requestRefundHotelOrder, callParams);

        yield put(refundHotelOrderRequestSuccess());

        addToast('Отмена заказа запущена', {
            appearance: 'success',
            autoDismiss: true,
        });
    } catch (error) {
        addToast('Ошибка при отмене заказа', {
            appearance: 'error',
            autoDismiss: true,
        });

        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(refundHotelOrderRequestFailure(error.response.data));
        }
    }
}

export default function* calculateHotelOrderRefund() {
    yield takeLatest(getType(refundHotelOrderRequest), handleFetch);
}
