import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IOrderEditEmailRequestParams,
    orderEditEmailRequest,
    orderEditEmailRequestFailure,
    orderEditEmailRequestSuccess,
} from 'redux/reducers/order/actions';

import isAxiosError from 'lib/isAxiosError';

function requestEditOrderEmail(
    data: Omit<IOrderEditEmailRequestParams, 'addToast'>,
): Promise<AxiosResponse<any>> {
    return apiClient.post(`/api/orders/${data.orderId}/email`, data);
}

function* handleFetch(action: ActionType<typeof orderEditEmailRequest>) {
    const {
        payload: {addToast, ...editEmailParams},
    } = action;

    try {
        yield call(requestEditOrderEmail, editEmailParams);

        yield put(orderEditEmailRequestSuccess());

        addToast('Email изменен', {
            appearance: 'success',
            autoDismiss: true,
        });
    } catch (error) {
        addToast('Ошибка изменения email', {
            appearance: 'error',
            autoDismiss: true,
        });

        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(orderEditEmailRequestFailure(error.response.data));
        }
    }
}

export default function* orderEditEmail() {
    yield takeLatest(getType(orderEditEmailRequest), handleFetch);
}
