import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IOrderEditPayloadRequestParams,
    orderEditPayloadRequest,
    orderEditPayloadRequestFailure,
    orderEditPayloadRequestSuccess,
} from 'redux/reducers/order/actions';

import isAxiosError from 'lib/isAxiosError';

function requestEditOrderPayload(
    data: Omit<IOrderEditPayloadRequestParams, 'addToast'>,
): Promise<AxiosResponse<any>> {
    return apiClient.post(
        `/api/orders/${data.order_id}/payloads/${data.order_item_id}`,
        data,
    );
}

function* handleFetch(action: ActionType<typeof orderEditPayloadRequest>) {
    const {
        payload: {addToast, ...payload},
    } = action;

    try {
        yield call(requestEditOrderPayload, payload);

        yield put(orderEditPayloadRequestSuccess());

        addToast('Информация сохранена', {
            appearance: 'success',
            autoDismiss: true,
        });
    } catch (error) {
        addToast('Ошибка сохранения', {
            appearance: 'error',
            autoDismiss: true,
        });

        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(orderEditPayloadRequestFailure(error.response.data));
        }
    }
}

export default function* orderEditPayload() {
    yield takeLatest(getType(orderEditPayloadRequest), handleFetch);
}
