import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IOrderEditPhoneRequestParams,
    orderEditPhoneRequest,
    orderEditPhoneRequestFailure,
    orderEditPhoneRequestSuccess,
} from 'redux/reducers/order/actions';

import isAxiosError from 'lib/isAxiosError';

function requestEditOrderPhone(
    data: Omit<IOrderEditPhoneRequestParams, 'addToast'>,
): Promise<AxiosResponse<any>> {
    return apiClient.post(`/api/orders/${data.orderId}/phone`, data);
}

function* handleFetch(action: ActionType<typeof orderEditPhoneRequest>) {
    const {
        payload: {addToast, ...editPhoneParams},
    } = action;

    try {
        yield call(requestEditOrderPhone, editPhoneParams);

        yield put(orderEditPhoneRequestSuccess());

        addToast('Номер телефон изменен', {
            appearance: 'success',
            autoDismiss: true,
        });
    } catch (error) {
        addToast('Ошибка изменения номера телефона', {
            appearance: 'error',
            autoDismiss: true,
        });

        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(orderEditPhoneRequestFailure(error.response.data));
        }
    }
}

export default function* orderEditPhone() {
    yield takeLatest(getType(orderEditPhoneRequest), handleFetch);
}
