import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IOrderPayloadsRequestParams,
    orderPayloadsRequest,
    orderPayloadsRequestFailure,
    orderPayloadsRequestSuccess,
} from 'redux/reducers/order/actions';

import {IOrderPayloadInfo} from 'redux/reducers/types';

import isAxiosError from 'lib/isAxiosError';

export interface IOrderPayloadsResponse {
    order_id: string;
    order_payloads: IOrderPayloadInfo[];
}

function requestOrderPayloads({
    orderId,
}: IOrderPayloadsRequestParams): Promise<
    AxiosResponse<IOrderPayloadsResponse>
> {
    return apiClient.get(`/api/orders/${orderId}/payloads`);
}

function* handleFetch(action: ActionType<typeof orderPayloadsRequest>) {
    try {
        const {payload} = action;

        const {
            data: {order_payloads: orderPayloads},
        }: AxiosResponse<IOrderPayloadsResponse> = yield call(
            requestOrderPayloads,
            payload,
        );

        yield put(orderPayloadsRequestSuccess(orderPayloads));
    } catch (error) {
        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(orderPayloadsRequestFailure(error.response.data));
        }
    }
}

export default function* orderGetPayloads() {
    yield takeLatest(getType(orderPayloadsRequest), handleFetch);
}
