import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IOrderLogsRequestParams,
    orderLogsRequest,
    orderLogsRequestSuccess,
    orderLogsRequestFailure,
} from 'redux/reducers/order/actions';

import {IOrderLog} from 'redux/reducers/types';

import isAxiosError from 'lib/isAxiosError';

interface IOrderLogsResponse {
    records: IOrderLog[];
    count: number;
}

function requestOrderLogs({
    orderId,
    ...params
}: IOrderLogsRequestParams): Promise<AxiosResponse<IOrderLogsResponse>> {
    return apiClient.get(`/api/orders/${orderId}/logs`, {params});
}

function* handleFetch(action: ActionType<typeof orderLogsRequest>) {
    try {
        const {payload} = action;

        const {
            data: {records, count},
        }: AxiosResponse<IOrderLogsResponse> = yield call(
            requestOrderLogs,
            payload,
        );

        yield put(orderLogsRequestSuccess({records, count}));
    } catch (error) {
        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(orderLogsRequestFailure(error.response.data));
        }
    }
}

export default function* orderLogs() {
    yield takeLatest(getType(orderLogsRequest), handleFetch);
}
