import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IOrderRegenerateVouchersRequestParams,
    regenerateVouchersRequest,
    regenerateVouchersRequestSuccess,
    regenerateVouchersRequestFailure,
} from 'redux/reducers/order/actions';

import isAxiosError from 'lib/isAxiosError';

function requestOrderRegenerateVouchers(
    data: Omit<IOrderRegenerateVouchersRequestParams, 'addToast'>,
): Promise<AxiosResponse<any>> {
    return apiClient.post(
        `/api/orders/${data.orderId}/regenerateVouchers`,
        data,
    );
}

function* handleFetch(action: ActionType<typeof regenerateVouchersRequest>) {
    const {
        payload: {addToast, ...callParams},
    } = action;

    try {
        yield call(requestOrderRegenerateVouchers, callParams);

        yield put(regenerateVouchersRequestSuccess());

        addToast('Перегенерация запущена', {
            appearance: 'success',
            autoDismiss: true,
        });
    } catch (error) {
        addToast('Ошибка запуска перегенерации', {
            appearance: 'error',
            autoDismiss: true,
        });

        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(regenerateVouchersRequestFailure(error.response.data));
        }
    }
}

export default function* orderRegenerateVouchers() {
    yield takeLatest(getType(regenerateVouchersRequest), handleFetch);
}
