import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IOrderRestoreDolphinOrderRequestParams,
    restoreDolphinOrderRequest,
    restoreDolphinOrderRequestSuccess,
    restoreDolphinOrderRequestFailure,
} from 'redux/reducers/order/actions';

import isAxiosError from 'lib/isAxiosError';

function requestOrderSendNotification(
    data: Omit<IOrderRestoreDolphinOrderRequestParams, 'addToast'>,
): Promise<AxiosResponse<any>> {
    return apiClient.post(
        `/api/orders/${data.orderId}/restoreDolphinOrder`,
        data,
    );
}

function* handleFetch(action: ActionType<typeof restoreDolphinOrderRequest>) {
    const {
        payload: {addToast, ...callParams},
    } = action;

    try {
        yield call(requestOrderSendNotification, callParams);

        yield put(restoreDolphinOrderRequestSuccess());

        addToast('Восстановление запущено', {
            appearance: 'success',
            autoDismiss: true,
        });
    } catch (error) {
        addToast('Ошибка запуска восстановления', {
            appearance: 'error',
            autoDismiss: true,
        });

        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(restoreDolphinOrderRequestFailure(error.response.data));
        }
    }
}

export default function* orderRestoreDolphinOrder() {
    yield takeLatest(getType(restoreDolphinOrderRequest), handleFetch);
}
