import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IOrderRetryMoneyRefundRequestParams,
    orderRetryMoneyRefundRequest,
    orderRetryMoneyRefundRequestFailure,
    orderRetryMoneyRefundRequestSuccess,
} from 'redux/reducers/order/actions';

import isAxiosError from 'lib/isAxiosError';

function requestOrderRetryMoneyRefund(
    data: Omit<IOrderRetryMoneyRefundRequestParams, 'addToast'>,
): Promise<AxiosResponse<any>> {
    return apiClient.post(`/api/orders/${data.orderId}/retryMoneyRefund`, data);
}

function* handleFetch(action: ActionType<typeof orderRetryMoneyRefundRequest>) {
    const {
        payload: {addToast, ...retryMoneyRefundParams},
    } = action;

    try {
        yield call(requestOrderRetryMoneyRefund, retryMoneyRefundParams);

        yield put(orderRetryMoneyRefundRequestSuccess());

        addToast('Запустили возврат', {
            appearance: 'success',
            autoDismiss: true,
        });
    } catch (error) {
        addToast('Ошибка при возврате', {
            appearance: 'error',
            autoDismiss: true,
        });

        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(orderRetryMoneyRefundRequestFailure(error.response.data));
        }
    }
}

export default function* orderRetryMoneyRefund() {
    yield takeLatest(getType(orderRetryMoneyRefundRequest), handleFetch);
}
