import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    orderRequest,
    orderRequestSuccess,
    orderRequestFailure,
} from 'redux/reducers/order/actions';

import {IOrderInfo} from 'redux/reducers/types';

import isAxiosError from 'lib/isAxiosError';

export interface IFetchOrderResponse {
    order: IOrderInfo;
}

export function requestOrder({
    orderId,
    needToFetchPersonalData,
}: {
    orderId: string;
    needToFetchPersonalData: boolean;
}): Promise<AxiosResponse<IFetchOrderResponse>> {
    return apiClient.get(`/api/orders/${orderId}`, {
        params: {needToFetchPersonalData},
    });
}

function* handleFetch(action: ActionType<typeof orderRequest>) {
    try {
        const {payload} = action;

        const {
            data: {order},
        } = yield call(requestOrder, payload);

        yield put(orderRequestSuccess(order));
    } catch (error) {
        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(orderRequestFailure(error.response.data));
        }
    }
}

export default function* orderSaga() {
    yield takeLatest(getType(orderRequest), handleFetch);
}
