import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IOrderSendNotificationRequestParams,
    orderSendNotificationRequest,
    orderSendNotificationRequestFailure,
    orderSendNotificationRequestSuccess,
} from 'redux/reducers/order/actions';

import isAxiosError from 'lib/isAxiosError';

function requestOrderSendNotification(
    data: Omit<IOrderSendNotificationRequestParams, 'addToast'>,
): Promise<AxiosResponse<any>> {
    return apiClient.post(`/api/orders/${data.orderId}/sendNotification`, data);
}

function* handleFetch(action: ActionType<typeof orderSendNotificationRequest>) {
    const {
        payload: {addToast, ...sendNotificationParams},
    } = action;

    try {
        yield call(requestOrderSendNotification, sendNotificationParams);

        yield put(orderSendNotificationRequestSuccess());

        addToast('Уведомление отправлено', {
            appearance: 'success',
            autoDismiss: true,
        });
    } catch (error) {
        addToast('Ошибка отправки уведомления', {
            appearance: 'error',
            autoDismiss: true,
        });

        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(orderSendNotificationRequestFailure(error.response.data));
        }
    }
}

export default function* orderSendNotification() {
    yield takeLatest(getType(orderSendNotificationRequest), handleFetch);
}
