import {takeLatest, call, put} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {AxiosResponse} from 'axios';
import apiClient from 'services/apiClient';
import {
    IOrderWorkflowRequestParams,
    orderWorkflowRequest,
    orderWorkflowRequestSuccess,
    orderWorkflowRequestFailure,
} from 'redux/reducers/order/actions';

import isAxiosError from 'lib/isAxiosError';

function requestOrderWorkflow({
    workflowId,
}: IOrderWorkflowRequestParams): Promise<AxiosResponse<any>> {
    return apiClient.get(`/api/workflow/${workflowId}`);
}

function* handleFetch(action: ActionType<typeof orderWorkflowRequest>) {
    try {
        const {payload} = action;

        const {data: workflowData}: AxiosResponse<any> = yield call(
            requestOrderWorkflow,
            payload,
        );

        yield put(orderWorkflowRequestSuccess(workflowData));
    } catch (error) {
        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(orderWorkflowRequestFailure(error.response.data));
        }
    }
}

export default function* orderWorkflow() {
    yield takeLatest(getType(orderWorkflowRequest), handleFetch);
}
