import {takeLatest, call, put} from 'redux-saga/effects';
import {AxiosResponse} from 'axios';
import {getType, ActionType} from 'typesafe-actions';
import {
    ordersRequest,
    ordersRequestFailure,
    ordersRequestSuccess,
} from 'redux/reducers/orders/actions';

import {IFetchOrdersResponse} from 'redux/sagas/orders/helpers/types';

import {requestOrders} from 'redux/sagas/orders/helpers/requestOrders';
import isAxiosError from 'lib/isAxiosError';

function* handleFetch(action: ActionType<typeof ordersRequest>) {
    try {
        const {
            data: {orders, quantity},
        }: AxiosResponse<IFetchOrdersResponse> = yield call(
            requestOrders,
            action.payload,
        );

        yield put(
            ordersRequestSuccess({
                orders,
                overallItemsCount: Number(quantity),
            }),
        );
    } catch (error) {
        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(ordersRequestFailure(error.response.data));
        }
    }
}

export default function* fetchOrdersSaga() {
    yield takeLatest(getType(ordersRequest), handleFetch);
}
