import {takeLatest, call, put} from 'redux-saga/effects';
import {AxiosResponse} from 'axios';
import {getType, ActionType} from 'typesafe-actions';
import {
    ordersSearchFormOptionsRequest,
    ordersSearchFormOptionsRequestSuccess,
    ordersSearchFormOptionsRequestFailure,
} from 'redux/reducers/orders/actions';

import {IFetchOrdersResponse} from 'redux/sagas/orders/helpers/types';

import {requestOrders} from 'redux/sagas/orders/helpers/requestOrders';
import isAxiosError from 'lib/isAxiosError';

function* handleFetch(
    action: ActionType<typeof ordersSearchFormOptionsRequest>,
) {
    try {
        const {
            data: {
                order_state_values,
                display_order_type_values,
                order_partner_values,
            },
        }: AxiosResponse<IFetchOrdersResponse> = yield call(
            requestOrders,
            action.payload,
        );

        yield put(
            ordersSearchFormOptionsRequestSuccess({
                stateOptions: order_state_values,
                displayTypeOptions: display_order_type_values,
                partnerOptions: order_partner_values,
            }),
        );
    } catch (error) {
        if (isAxiosError(error) && error.response && error.response.data) {
            yield put(
                ordersSearchFormOptionsRequestFailure(error.response.data),
            );
        }
    }
}

export default function* fetchOrdersSearchFormOptionsSaga() {
    yield takeLatest(getType(ordersSearchFormOptionsRequest), handleFetch);
}
