import {all} from 'redux-saga/effects';
import orderRestoreDolphinOrder from 'redux/sagas/order/orderRestoreDolphinOrder';
import orderRegenerateVouchers from 'redux/sagas/order/orderRegenerateVouchers';
import hotelOrderCalculateRefund from 'redux/sagas/order/hotelOrderCalculateRefund';
import hotelOrderRefund from 'redux/sagas/order/hotelOrderRefund';
import hotelMoneyOnlyCalculateRefund from 'redux/sagas/order/hotelMoneyOnlyCalculateRefund';
import hotelMoneyOnlyRefund from 'redux/sagas/order/hotelMoneyOnlyRefund';
import hotelOrderModifyDetails from 'redux/sagas/order/hotelOrderModifyDetails';

import watchRequestsErrors from './common/watchRequestsErrors';
import ordersSaga from './orders/rootSaga';
import orderSaga from './order/orderSaga';
import orderLogsSaga from './order/orderLogs';
import orderWorkflowSaga from './order/orderWorkflow';
import orderGetPayloadsSaga from './order/orderGetPayloads';
import orderEditPayload from './order/orderEditPayload';
import orderEditEmail from './order/orderEditEmail';
import orderEditPhone from './order/orderEditPhone';
import orderSendNotification from './order/orderSendNotification';
import orderRetryMoneyRefund from './order/orderRetryMoneyRefund';
import orderUpdateTrainTickets from './order/orderUpdateTrainTickets';
import orderRefund from './order/orderRefund';
import orderStartrekTickets from './order/orderStartrekTickets';

export default function* rootSaga() {
    yield all([
        watchRequestsErrors(),
        ordersSaga(),
        orderSaga(),
        orderLogsSaga(),
        orderWorkflowSaga(),
        orderGetPayloadsSaga(),
        orderEditPayload(),
        orderEditEmail(),
        orderEditPhone(),
        orderSendNotification(),
        orderRetryMoneyRefund(),
        orderUpdateTrainTickets(),
        orderRefund(),
        orderStartrekTickets(),
        orderRestoreDolphinOrder(),
        orderRegenerateVouchers(),
        hotelOrderCalculateRefund(),
        hotelOrderRefund(),
        hotelMoneyOnlyCalculateRefund(),
        hotelMoneyOnlyRefund(),
        hotelOrderModifyDetails(),
    ]);
}
