import {createStore, applyMiddleware, DeepPartial} from 'redux';
import {composeWithDevTools} from 'redux-devtools-extension';
import createSagaMiddleware from 'redux-saga';
import rootSaga from 'redux/sagas/rootSaga';

import {IStore} from 'redux/reducers/types';

import rootReducer from './reducers/rootReducer';

const sagaMiddleware = createSagaMiddleware();

const preLoadedReduxState: DeepPartial<IStore> = {};

if (typeof window !== 'undefined') {
    preLoadedReduxState.userInfo = {
        hasAccess: true,
    };

    preLoadedReduxState.env = window.__DATA__.env;
}

const store = createStore(
    rootReducer,
    preLoadedReduxState as any,
    composeWithDevTools(applyMiddleware(sagaMiddleware)),
);

sagaMiddleware.run(rootSaga);

export default store;
