package ru.yandex.travel.acceptance.orders.invoice.trust;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public class CheckerRegistry {
    private ConcurrentMap<UUID, TrustInvoiceCheckerBase> registeredCheckers = new ConcurrentHashMap<>();

    public void registerChecker(UUID workflowId, TrustInvoiceCheckerBase checkerBase) {
        registeredCheckers.put(workflowId, checkerBase);
    }

    public TrustInvoiceCheckerBase getCheckerHandlerForWorkflow(UUID workflowId) {
        return registeredCheckers.get(workflowId);
    }

}
