package ru.yandex.travel.acceptance.orders.invoice.trust;

import java.util.Collections;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.StandardEnvironment;

import ru.yandex.travel.acceptance.AcceptanceUtils;
import ru.yandex.travel.workflow.WorkflowProcessingProperties;

// TODO (mbobrov): think of using spring-shell
@SpringBootApplication(
        scanBasePackages = {"ru.yandex.travel.orders", "ru.yandex.travel.acceptance.orders.invoice.trust"}
)
@Slf4j
public class TrustInvoiceAcceptanceApplication implements CommandLineRunner {

    @Autowired
    private ConfigurableApplicationContext context;

    @Autowired
    private TestsRunner testsRunner;

    @Autowired
    private WorkflowProcessingProperties workflowProcessingProperties;

    public static void main(String[] args) {
        StandardEnvironment environment = new StandardEnvironment();
        environment.setActiveProfiles("acceptance"); //TODO (mbobrov): think of a better way to handle active profiles
        environment.getPropertySources().addLast(new MapPropertySource("ignored-properties", Map.of(
                "expedia.connection.secret", "not_used"
        )));

        AcceptanceUtils.setPropertiesFromVault("ver-01d6wq2azwmxf030mw27k2k0fg",
                Collections.singletonMap("value", "trust-hotels.serviceToken"),
                environment);

        SpringApplication application = new SpringApplication(TrustInvoiceAcceptanceApplication.class);
        application.setEnvironment(environment);
        application.setWebApplicationType(WebApplicationType.NONE);

        application.run();
    }

    @Override
    public void run(String... args) {
        boolean holdClearRefundSuccess = testsRunner.checkHoldClearRefund();
        log.info("HOLD->CLEAR->REFUND: {}", holdClearRefundSuccess);
        boolean holdUnholdSuccess = testsRunner.checkHoldUnhold();
        log.info("HOLD->UNHOLD: {}", holdUnholdSuccess);
        if (!holdClearRefundSuccess) {
            log.warn("HOLD->CLEAR->REFUND test failed", new RuntimeException());
        }
        if (!holdUnholdSuccess) {
            log.warn("HOLD->UNHOLD test failed", new RuntimeException());
        }
        SpringApplication.exit(context); // TODO (mbobrov): think of how we can use spring application exit code here
        boolean testPassed = holdClearRefundSuccess && holdUnholdSuccess;
        int exitCode = testPassed ? 0 : 1;
        System.exit(exitCode);
    }
}
