package ru.yandex.travel.acceptance.orders.invoice.trust;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

import ru.yandex.travel.orders.entities.Invoice;
import ru.yandex.travel.workflow.base.AnnotatedWorkflowEventHandler;

public class TrustInvoiceCheckerBase extends AnnotatedWorkflowEventHandler<Invoice> {
    protected final TrustPayer trustPayer;

    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean testPassed = new AtomicBoolean(false);

    public TrustInvoiceCheckerBase(TrustPayer trustPayer) {
        this.trustPayer = trustPayer;
    }

    protected void fail() {
        testPassed.set(false);
        latch.countDown();
    }

    protected void pass() {
        testPassed.set(true);
        latch.countDown();
    }

    protected CardParams createCardParams() {
        return CardParams.builder()
                .cardNumber("5100009632067772") // TODO (mbobrov): move card generation further
                .expiresAtMonth("10")
                .expiresAtYear("25")
                .cvc("777") // lucky seven
                .build();
    }


    public boolean waitTestResult(Duration awaitDuration) {
        try {
            boolean notInterrupted = latch.await(awaitDuration.toNanos(), TimeUnit.NANOSECONDS);
            return testPassed.get() && notInterrupted;
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}
