package ru.yandex.travel.acceptance.orders.orderitem.expedia;

import java.util.Collections;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.StandardEnvironment;

import ru.yandex.travel.acceptance.AcceptanceUtils;
import ru.yandex.travel.orders.workflow.order.proto.TServiceCancelled;
import ru.yandex.travel.orders.workflow.order.proto.TServiceConfirmed;
import ru.yandex.travel.orders.workflow.order.proto.TServiceRefunded;
import ru.yandex.travel.orders.workflow.order.proto.TServiceReserved;
import ru.yandex.travel.workflow.WorkflowMessageSender;

// TODO (mbobrov): think of using spring-shell
@SpringBootApplication(
        scanBasePackages = {"ru.yandex.travel.orders", "ru.yandex.travel.acceptance.orders.orderitem.expedia"}
)
@Slf4j
public class ExpediaAcceptanceApplication implements CommandLineRunner {
    @Autowired
    private ConfigurableApplicationContext context;

    @Autowired
    private CheckerHandlerFactory checkerFactory;

    @Autowired
    private WorkflowMessageSender workflowMessageSender;

    public static void main(String[] args) {
        StandardEnvironment environment = new StandardEnvironment();
        environment.setActiveProfiles("acceptance"); //TODO (mbobrov): think of a better way to handle active profiles

        AcceptanceUtils.setPropertiesFromVault("ver-01d6wq9wwdwy6jq5j68fmkqgmt",
                Collections.singletonMap("value", "expedia.connection.secret"),
                environment);

        SpringApplication application = new SpringApplication(ExpediaAcceptanceApplication.class);
        application.setEnvironment(environment);
        application.setWebApplicationType(WebApplicationType.NONE);

        application.run();
    }

    @Override
    public void run(String... args) {
        checkerFactory.testExpect(ExpectedTestResult.Outcome.SUCCESS)
                .getsMessage(TServiceReserved.class).andThen(TServiceConfirmed.class).andThen(TServiceRefunded.class).andThenDone()
                .run(workflowMessageSender);
        checkerFactory.testExpect(ExpectedTestResult.Outcome.FX_RATE_CHECK_FAILURE)
                .getsMessage(TServiceCancelled.class).andThenDone().run(workflowMessageSender);
        // TODO (tivelkov): fix it, maybe reworking the scenario
//        checkerFactory.testExpect(ExpectedTestResult.Outcome.HOLD_FAILURE,
//                ExpectedTestResult.ErrorToSimulate.PRICE_MISMATCH)
//                .getsMessage(TServiceCancelled.class).andThenDone()
//                .run(workflowProcessService);


        boolean passed = checkerFactory.waitAll();
        SpringApplication.exit(context);
        if (!passed) {
            log.warn("Some tests failed", new RuntimeException(checkerFactory.waitAndDescribeAll()));
        }
        int exitCode = passed ? 0 : 1;
        System.exit(exitCode);
    }
}
