package ru.yandex.travel.acceptance.orders.orderitem.expedia;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.workflow.MessagingContextFactory;
import ru.yandex.travel.workflow.WorkflowEventHandlerMatcher;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(ExpediaAcceptanceProperties.class)
public class ExpediaAcceptanceConfiguration {
    private final CheckerHandlerFactory handlerFactory;


    @Bean
    public WorkflowEventHandlerMatcher workflowEventHandlerMatcher() {
        return handlerFactory.getHandlerMatcher();
    }

    @Bean
    public MessagingContextFactory messagingContextFactory(CheckerHandlerFactory handlerFactory) {
        return handlerFactory.getMessagingContextFactory();
    }
}
