package ru.yandex.travel.acceptance.orders.orderitem.train;

import java.util.HashMap;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.StandardEnvironment;

import ru.yandex.travel.acceptance.AcceptanceUtils;
import ru.yandex.travel.workflow.WorkflowProcessService;

@SpringBootApplication(
        scanBasePackages = {"ru.yandex.travel.orders", "ru.yandex.travel.acceptance.orders.orderitem.train"}
)
@Slf4j
public class TrainAcceptanceApplication implements CommandLineRunner {
    @Autowired
    private ConfigurableApplicationContext context;

    @Autowired
    private WorkflowProcessService workflowProcessService;

    @Autowired
    private TrainCheckerHandlerManager checkerHandlerManager;

    public static void main(String[] args) {
        StandardEnvironment environment = new StandardEnvironment();
        environment.setActiveProfiles("acceptance");
        environment.getPropertySources().addLast(new MapPropertySource("ignored-properties", Map.of(
                "expedia.connection.secret", "not_used"
        )));

        AcceptanceUtils.setPropertiesFromVault("sec-01dznp44a7qvrhd04yevxj5gkv",
                new HashMap<>() {{
                    put("login", "im.login");
                    put("pos", "im.pos");
                    put("password", "im.password");
                }},
                environment);

        SpringApplication application = new SpringApplication(TrainAcceptanceApplication.class);
        application.setEnvironment(environment);
        application.setWebApplicationType(WebApplicationType.NONE);

        application.run();
    }

    @Override
    public void run(String... args) {
        checkerHandlerManager.runConfirmRefundChecker(workflowProcessService);
        checkerHandlerManager.runReserveCancelChecker(workflowProcessService);

        boolean passed = checkerHandlerManager.waitAll();
        SpringApplication.exit(context);
        if (!passed) {
            log.warn("Some tests failed", new RuntimeException(checkerHandlerManager.waitAndDescribeAll()));
        }
        int exitCode = passed ? 0 : 1;
        System.exit(exitCode);
    }
}
