package ru.yandex.travel.acceptance.orders.orderitem.train;

import java.util.ArrayList;
import java.util.Arrays;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.dicts.rasp.proto.TTrainTariffInfo;
import ru.yandex.travel.orders.configurations.TrainTariffInfoDataProviderProperties;
import ru.yandex.travel.orders.services.train.tariffinfo.TrainTariffInfoService;
import ru.yandex.travel.workflow.MessagingContextFactory;
import ru.yandex.travel.workflow.WorkflowEventHandlerMatcher;
import ru.yandex.travel.yt_lucene_index.TestLuceneIndexBuilder;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(TrainAcceptanceProperties.class)
public class TrainAcceptanceConfiguration {
    @Bean
    public WorkflowEventHandlerMatcher workflowEventHandlerMatcher(TrainCheckerHandlerManager handlerFactory) {
        return handlerFactory.getHandlerMatcher();
    }

    @Bean
    public MessagingContextFactory messagingContextFactory(TrainCheckerHandlerManager handlerFactory) {
        return handlerFactory.getMessagingContextFactory();
    }

    @Bean
    public TrainTariffInfoService trainTariffInfoService() {
        var tariffInfos = Arrays.asList(
                TTrainTariffInfo.newBuilder()
                        .setId(1)
                        .setCode("full")
                        .setTitleRu("full")
                        .setImRequestCode("Full")
                        .setImResponseCodes("Full,Senior")
                        .setWithoutPlace(false)
                        .setMinAge(0)
                        .setMinAgeIncludesBirthday(false)
                        .setMaxAge(150)
                        .setMaxAgeIncludesBirthday(false)
                        .setNeedDocument(false).build(),
                TTrainTariffInfo.newBuilder()
                        .setId(2)
                        .setCode("baby")
                        .setTitleRu("baby")
                        .setImRequestCode("Full")
                        .setImResponseCodes("FreeChild")
                        .setWithoutPlace(true)
                        .setMinAge(0)
                        .setMinAgeIncludesBirthday(false)
                        .setMaxAge(5)
                        .setMaxAgeIncludesBirthday(true)
                        .setNeedDocument(false).build(),
                TTrainTariffInfo.newBuilder()
                        .setId(3)
                        .setCode("child")
                        .setTitleRu("child")
                        .setImRequestCode("Full")
                        .setImResponseCodes("Child")
                        .setWithoutPlace(false)
                        .setMinAge(0)
                        .setMinAgeIncludesBirthday(false)
                        .setMaxAge(10)
                        .setMaxAgeIncludesBirthday(true)
                        .setNeedDocument(false).build());

        TrainTariffInfoDataProviderProperties config = new TrainTariffInfoDataProviderProperties();
        config.setTablePath("tablePath");
        config.setIndexPath("./train-tariff-index");
        config.setProxy(new ArrayList<>());

        TestLuceneIndexBuilder<TTrainTariffInfo> luceneIndexBuilder = new TestLuceneIndexBuilder<TTrainTariffInfo>()
                .setLuceneData(tariffInfos);

        return new TrainTariffInfoService(config, luceneIndexBuilder);
    }
}
