package ru.yandex.travel.acceptance.orders.orderitem.train;

import java.time.Duration;
import java.time.LocalTime;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Getter
@Setter
@ConfigurationProperties("acceptance.train")
public class TrainAcceptanceProperties {
    private Integer departureDayAfterNow;
    private LocalTime departureTime;
    private Duration maxTestDuration;

    public void setDepartureTime(String value) {
        departureTime = LocalTime.parse(value);
    }
}
