package ru.yandex.travel.acceptance.orders.orderitem.train;

import java.util.LinkedList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.TrainOrderItem;
import ru.yandex.travel.orders.workflow.order.proto.TServiceCancelled;
import ru.yandex.travel.orders.workflow.order.proto.TServiceReserved;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.TCancellationStart;
import ru.yandex.travel.workflow.MessagingContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class TrainReserveCancelCheckerHandler extends BaseTrainCheckerHandler {
    TrainReserveCancelCheckerHandler() {
        super(EOrderItemState.IS_CANCELLED, new LinkedList<>(List.of(
                TServiceReserved.class, TServiceCancelled.class)));
    }

    @HandleEvent
    public void handleReserved(TServiceReserved message, MessagingContext<TrainOrderItem> messagingContext) {
        log.info("Order is reserved. Let's cancel the reservation now");
        TrainOrderItem item = messagingContext.getWorkflowEntity();
        storeActualState(item);
        checkMessageInSequence(message);
        messagingContext.scheduleExternalEvent(item.getWorkflow().getId(), TCancellationStart.newBuilder().build());
    }

    @HandleEvent
    public void handleCancelled(TServiceCancelled message, MessagingContext<TrainOrderItem> messagingContext) {
        log.info("Order is canceled.");
        storeActualState(messagingContext.getWorkflowEntity());
        checkMessageInSequence(message);
    }
}
