package ru.yandex.travel.acceptance.orders.vault;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import lombok.Value;

public class VaultPropertiesLoader {
    @Value
    public static final class VaultProperty {
        private String version;
        private String key;
    }

    private final VaultClient vaultClient;

    public VaultPropertiesLoader(String oauthToken, VaultClient.Type vaultType) {
        this.vaultClient = new VaultClient(oauthToken, vaultType);
    }

    public String getProperty(VaultProperty key) {
        VersionResponse versionResponse = vaultClient.getVersion(key.getVersion());
        return versionResponse.getVersion().getValue().stream().filter(v -> key.getKey().equals(v.getKey()))
                .findFirst().map(VaultVersionValue::getValue).get();
    }

    /**
     * Gets list of keys from the version.
     */
    public Map<String, String> getProperties(String version, Collection<String> keys) {
        return vaultClient.getVersion(version)
                .getVersion()
                .getValue()
                .stream()
                .reduce(new HashMap<>(), (map, value) -> {
                    if (keys.contains(value.getKey())) {
                        map.put(value.getKey(), value.getValue());
                    }
                    return map;
                }, (a, b) -> a);
    }
}
