#!/usr/bin/env python

import os
import subprocess
import sys

SERVICE_NAME = "orders-acceptance"
MAIN_CLASS = "{{mainClass}}"


def get_log_dir():
    return get_env_value_or_default("BASE_LOG_DIR", os.path.join("/logs", SERVICE_NAME))


def get_base_dir():
    return os.path.join(os.path.dirname(os.path.abspath(__file__)), "..")


def get_lib_dir():
    return os.path.join(get_base_dir(), SERVICE_NAME)


def get_classpath():
    jar_dir = os.path.join(SERVICE_NAME, "*")
    return jar_dir


def get_java_args():
    return [
        "-DLOG_DIR={}".format(get_log_dir()),
        "-Djava.library.path={}".format(get_lib_dir()),

        # gc
        "-XX:MaxHeapSize={}".format(get_heap_size()),
        "-verbose:gc",
        "-Xlog:gc:{}/gc-%t.log".format(get_log_dir()),
        "-XX:ErrorFile={}/hs_err.log".format(get_log_dir()),
        "-XX:+HeapDumpOnOutOfMemoryError",
        "-XX:HeapDumpPath={}/hprof/".format(get_log_dir()),
        "-XX:OnOutOfMemoryError=kill",
        "-Xdebug",

        # ipv6
        "-Djava.net.preferIPv6Addresses=true",
        "-Djava.net.preferIPv4Stack=false",

        # i/o
        "-Dfile.encoding=UTF-8"
    ]


def get_heap_size():
    heap_size = os.environ.get("JAVA_HEAP_SIZE")
    if heap_size is None:
        heap_size = "3G"
    return heap_size


def get_java_binary():
    return get_env_value_or_default("JAVA_BINARY", "/usr/bin/java")


def get_env_value_or_default(env_var_name, default):
    val = os.environ.get(env_var_name)
    if val is None:
        val = default
    return val


if __name__ == '__main__':
    call_args = [get_java_binary()]
    call_args.extend(get_java_args())
    call_args.append("-classpath")
    call_args.append(get_classpath())
    call_args.append(MAIN_CLASS)
    sys.exit(subprocess.call(call_args))
