RECURSE(
    test
)

JAVA_PROGRAM(orders-acceptance)

JDK_VERSION(11)

INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

OWNER(g:travel)

JAVA_SRCS(SRCDIR java **/*)
JAVA_SRCS(SRCDIR resources **/*)

WITH_JDK()

EXCLUDE(
    contrib/java/org/mockito/mockito-core/1.9.5
    contrib/java/ch/qos/logback/logback-core
)

PEERDIR(
    travel/orders/app
    travel/library/java/commons
    travel/library/java/testing-commons
    travel/library/java/yt-lucene-index-test

    contrib/java/junit/junit
    contrib/java/com/google/code/gson/gson
    contrib/java/org/springframework/spring-test
    contrib/java/org/springframework/boot/spring-boot-starter-test
    contrib/java/com/github/tomakehurst/wiremock-standalone/2.18.0
    contrib/java/io/grpc/grpc-testing
    contrib/java/org/assertj/assertj-core
    contrib/java/org/seleniumhq/selenium/selenium-api/3.7.1
    contrib/java/org/seleniumhq/selenium/selenium-java/3.7.1
    contrib/java/org/seleniumhq/selenium/selenium-support/3.7.1
    contrib/java/org/seleniumhq/selenium/selenium-remote-driver/3.7.1
    # think of redefining it in dependencies
    contrib/java/com/google/guava/guava/23.0
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/orders/app/acceptance/starter.template.py
    OUT ${BINDIR}/bin/trust_invoice_acceptance_test.py
    CUSTOM_PROPERTY mainClass "ru.yandex.travel.acceptance.orders.invoice.trust.TrustInvoiceAcceptanceApplication"
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/orders/app/acceptance/starter.template.py
    OUT ${BINDIR}/bin/expedia_acceptance_test.py
    CUSTOM_PROPERTY mainClass "ru.yandex.travel.acceptance.orders.orderitem.expedia.ExpediaAcceptanceApplication"
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/orders/app/acceptance/starter.template.py
    OUT ${BINDIR}/bin/train_acceptance_test.py
    CUSTOM_PROPERTY mainClass "ru.yandex.travel.acceptance.orders.orderitem.train.TrainAcceptanceApplication"
)

LINT(base)
END()
