package ru.yandex.travel.orders;

import io.grpc.Context;
import io.grpc.testing.GrpcCleanupRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import ru.yandex.travel.credentials.UserCredentials;

/**
 * @see ReflectionEnhancedAbstractGrpcTest
 */
@RunWith(SpringRunner.class)
@SpringBootTest(
        webEnvironment = SpringBootTest.WebEnvironment.MOCK
)
@ActiveProfiles("test")
public abstract class AbstractGrpcTest {
    public static final String DEFAULT_TEST_YANDEX_UID = "987654321";
    public static final String DEFAULT_TEST_PASSPORT_ID = "42";
    public static final String DEFAULT_TEST_LOGIN = "login";
    public static final String DEFAULT_SESSION_KEY = "qwerty";

    @Rule
    public GrpcCleanupRule cleanupRule = new GrpcCleanupRule();

    protected Context rootTestContext;

    @Before
    public void init() {
        rootTestContext = Context.current();
    }

    @After
    public void tearDown() {
        Context.current().detach(rootTestContext);
    }

    protected void bindCredentials(UserCredentials credentials) {
        Context.current().withValue(UserCredentials.KEY, credentials).attach();
    }

    protected void mockAnonymousUser(String yandexUid, String sessionKey) {
        bindCredentials(new UserCredentials(sessionKey, yandexUid, null, null, null, "127.0.0.1", false, false));
    }

    protected void mockUser(String yandexUid, String passportId) {
        bindCredentials(new UserCredentials(null, yandexUid, passportId, null, null, "127.0.0.1", false, false));
    }

    protected void mockUser(String yandexUid, String passportId, String login) {
        bindCredentials(new UserCredentials(null, yandexUid, passportId, login, null, "127.0.0.1", false, false));
    }

    protected void mockDefaultUser() {
        bindCredentials(new UserCredentials(null,
                DEFAULT_TEST_YANDEX_UID, DEFAULT_TEST_PASSPORT_ID, DEFAULT_TEST_LOGIN, null, "127.0.0.1", false,
                false));
    }

    protected void mockDefaultUserLoggedOut() {
        bindCredentials(
                new UserCredentials(DEFAULT_SESSION_KEY, DEFAULT_TEST_YANDEX_UID,
                        null, null, null, "127.0.0.1", false, false)
        );
    }

}
