package ru.yandex.travel.orders;

import java.lang.reflect.ParameterizedType;

import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.stub.AbstractBlockingStub;
import lombok.SneakyThrows;
import org.junit.Before;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import ru.yandex.travel.orders.integration.TestGrpcContext;

/**
 * Uses some black magic.
 * <p>
 * Main reason for implementing the service - I thought it would be difficult.
 */
public abstract class ReflectionEnhancedAbstractGrpcTest
        <
                S extends BindableService,
                C extends AbstractBlockingStub<C>>
        extends AbstractGrpcTest implements ApplicationContextAware {

    protected S service;
    protected C client;

    @Before
    public void setUpClient() {
        client = createStubClientAndMockUser(service, interfaceClass());
    }

    public void setApplicationContext(ApplicationContext context) {
        service = context.getBean(getServiceType());
    }

    @SuppressWarnings("unchecked")
    private Class<S> getServiceType() {
        return (Class<S>) ((ParameterizedType) this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    /**
     * @return class like MyCoolServiceInterfaceV1Grpc
     */
    @SneakyThrows
    private Class<?> interfaceClass() {
        return Class.forName(getServiceType().getSuperclass().getName().split("\\$")[0]);
    }

    @SneakyThrows
    protected <Z> C createStubClientAndMockUser(BindableService service,
                                                Class<Z> clazz) {
        TestGrpcContext context = TestGrpcContext.createTestServer(cleanupRule, service);
        @SuppressWarnings("unchecked")
        var client = (C) clazz.getMethod("newBlockingStub", Channel.class).invoke(null, context.createChannel());
        mockDefaultUser();
        return client;
    }
}
