package ru.yandex.travel.orders.configurations;

import java.util.List;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import lombok.extern.slf4j.Slf4j;
import org.junit.Ignore;
import org.junit.Test;

import ru.yandex.travel.orders.services.cloud.s3.S3ServiceProperties;
import ru.yandex.travel.tvm.TvmWrapper;

import static java.util.stream.Collectors.toList;
import static org.assertj.core.api.Assertions.assertThat;

@Slf4j
@Ignore
public class S3ConfigurationLocalTest {
    private static final S3Configuration configuration = new S3Configuration();

    public static AmazonS3 createManualTestsClient() {
        S3IdmAccessData accessData = S3IdmAccessData.loadLocalToken();
        return configuration.s3client(S3ServiceProperties.builder()
                .endpoint("https://s3.mds.yandex.net")
                .accessKey(accessData.getAccessKeyId())
                .accessSecret(accessData.getAccessSecretKey())
                .build(), null);
    }

    public static AmazonS3 createManualTestsClientWithTvm(TvmWrapper tvm, String s3Alias) {
        return configuration.s3client(S3ServiceProperties.builder()
                .endpoint("https://s3.mds.yandex.net")
                .useTvm(true)
                .tvmAlias(s3Alias)
                .build(), tvm);
    }

    @Test
    public void testClientConfiguration() {
        AmazonS3 client = createManualTestsClient();

        List<String> bucketNames = client.listBuckets().stream().map(Bucket::getName).collect(toList());
        assertThat(bucketNames).contains("order-service-dev");

        log.info("Buckets: {}", bucketNames);

        // optional, calling it just for reference
        client.shutdown();
    }

    @Test
    public void testClientConfigurationWithTvm() {
        try (TvmWrapper tvm = TvmConfigurationLocalTest.createDefaultManualTestsTvmClient()) {
            AmazonS3 client = createManualTestsClientWithTvm(tvm, "s3_prod");

            List<String> bucketNames = client.listBuckets().stream().map(Bucket::getName).collect(toList());
            assertThat(bucketNames).contains("order-service-dev");

            log.info("Buckets: {}", bucketNames);

            // optional, calling it just for reference
            client.shutdown();
        }
    }
}
