package ru.yandex.travel.orders.configurations;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import lombok.extern.slf4j.Slf4j;
import org.junit.Ignore;
import org.junit.Test;

import ru.yandex.travel.testing.local.LocalTestUtils;
import ru.yandex.travel.tvm.TvmHelper;
import ru.yandex.travel.tvm.TvmProperties;
import ru.yandex.travel.tvm.TvmWrapper;

import static java.util.stream.Collectors.joining;

@Slf4j
@Ignore
public class TvmConfigurationLocalTest {
    public static final BiMap<String, Integer> WELL_KNOWN_TVM_SERVICES = ImmutableBiMap.<String, Integer>builder()
            .put("avia_td_api_prod", 2000607)
            .put("avia_td_api_testing", 2000589)
            .put("avia_td_prod", 2000934)
            .put("orders_app_prod", 2002742)
            .put("orders_app_testing", 2002740)
            .put("s3_prod", 2017579)
            .put("travel_api_prod", 2002546)
            .put("travel_api_testing", 2002548)
            .build();

    public static TvmWrapper createDefaultManualTestsTvmClient() {
        return createManualTestsTvmClient("orders_app_testing");
    }

    public static TvmWrapper createManualTestsTvmClient(String selfAlias) {
        return TvmHelper.getTvmWrapper(TvmProperties.builder()
                .clientId(WELL_KNOWN_TVM_SERVICES.get(selfAlias))
                .clientSecret(LocalTestUtils.readLocalToken(".tvm/" + selfAlias + ".secret"))
                .serviceAliasIdMapping(WELL_KNOWN_TVM_SERVICES.entrySet().stream()
                        .map(e -> e.getKey() + "=" + e.getValue())
                        .collect(joining(",")))
                .dstServiceAliases(String.join(",", WELL_KNOWN_TVM_SERVICES.keySet()))
                .build());
    }

    @Test
    public void test() {
        try (TvmWrapper tvm = createDefaultManualTestsTvmClient()) {
            log.info("Tvm ticket:\n\n{}\n", tvm.getServiceTicket("s3_prod"));
        }
    }
}
