package ru.yandex.travel.orders.grpc;

import java.time.Instant;
import java.time.temporal.ChronoUnit;

import io.grpc.StatusRuntimeException;
import org.junit.Before;
import org.junit.Test;
import org.springframework.boot.test.mock.mockito.MockBean;

import ru.yandex.travel.orders.ReflectionEnhancedAbstractGrpcTest;
import ru.yandex.travel.orders.entities.promo.PromoAction;
import ru.yandex.travel.orders.entities.promo.PromoCode;
import ru.yandex.travel.orders.repository.promo.PromoCodeRepository;
import ru.yandex.travel.orders.services.promo.proto.PromoCodesOperatorManagementInterfaceV1Grpc;
import ru.yandex.travel.orders.services.promo.proto.TPromoCodeActivationAvailableReq;
import ru.yandex.travel.orders.services.promo.proto.TPromoCodeActivationAvailableResp;

import static org.junit.Assert.assertSame;
import static org.mockito.Mockito.when;
import static ru.yandex.travel.orders.commons.proto.EPromoCodeApplicationResultType.ART_EXPIRED;
import static ru.yandex.travel.orders.commons.proto.EPromoCodeApplicationResultType.ART_NOT_APPLICABLE;
import static ru.yandex.travel.orders.commons.proto.EPromoCodeApplicationResultType.ART_SUCCESS;

public class PromoCodesOperatorManagementServiceCheckPromoAvailableTest
        extends ReflectionEnhancedAbstractGrpcTest<PromoCodesOperatorManagementService,
        PromoCodesOperatorManagementInterfaceV1Grpc.PromoCodesOperatorManagementInterfaceV1BlockingStub> {
    public static final String CODE_STRING = "CODE";

    @MockBean
    private PromoCodeRepository repo;

    private PromoCode promoCode;


    @Before
    public void setUp() {
        promoCode = new PromoCode();
        promoCode.setCode(CODE_STRING);
        promoCode.setValidFrom(Instant.now().minus(1, ChronoUnit.HOURS));
        promoCode.setPromoAction(new PromoAction());
        when(repo.findByCodeEquals(CODE_STRING)).thenReturn(promoCode);
    }

    @Test
    public void returnsSuccessWhenEverythingIsFine() {
        assertSame(ART_SUCCESS, result().getResult());
    }

    @Test(expected = StatusRuntimeException.class)
    public void throwsAnErrorWhenCodeIsMalformed() {
        promoCode.setPromoAction(null);
        result();
    }

    @Test
    public void returnsExpiredWhenTheCodeIsOutdated() {
        promoCode.setValidTill(Instant.now().minus(1, ChronoUnit.MINUTES));
        assertSame(ART_EXPIRED, result().getResult());
    }
    @Test
    public void politelyReturnsNotApplicableWhenBlacklisted() {
        promoCode.setBlacklisted(true);
        assertSame(ART_NOT_APPLICABLE, result().getResult());
    }

    private TPromoCodeActivationAvailableResp result() {
        return client.promoCodeActivationAvailable(
                TPromoCodeActivationAvailableReq
                        .newBuilder()
                        .setCode(CODE_STRING)
                        .build());
    }
}
