package ru.yandex.travel.orders.integration.hotels;

import org.junit.Test;
import org.springframework.boot.test.mock.mockito.MockBean;

import ru.yandex.travel.hotels.common.orders.CancellationDetails;
import ru.yandex.travel.orders.commons.proto.EServiceType;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.doThrow;

public class AgreementOrderFlowTest extends AbstractHotelOrderFlowTest{

    @MockBean
    private BillingPartnerService billingPartnerService;

    private void initializeThrowAgreement() {
        doThrow(new RuntimeException("test exception for agreement")).when(billingPartnerService).addAgreementOrThrow(any());
    }

    @Test
    public void testBNovoFailedAgreementOnReservation() {
        initializeThrowAgreement();
        var orderId = createOrder(CreateOrderParams.builder()
                .serviceType(EServiceType.PT_BNOVO_HOTEL)
                .payloadName(PAYLOAD_BNOVO)
                .build());
        failOnReservation(orderId, CancellationDetails.Reason.SOLD_OUT);
    }
}
