package ru.yandex.travel.orders.integration.train.factories;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

import lombok.Getter;
import lombok.Setter;

import ru.yandex.travel.train.partners.im.model.ImBlankStatus;
import ru.yandex.travel.train.partners.im.model.PendingElectronicRegistration;
import ru.yandex.travel.train.partners.im.model.orderinfo.ImOperationStatus;
import ru.yandex.travel.train.partners.im.model.orderinfo.ImOperationType;
import ru.yandex.travel.train.partners.im.model.orderinfo.ImOrderItemType;
import ru.yandex.travel.train.partners.im.model.orderinfo.OrderInfoResponse;
import ru.yandex.travel.train.partners.im.model.orderinfo.OrderItemBlank;
import ru.yandex.travel.train.partners.im.model.orderinfo.OrderItemResponse;

@Getter
@Setter
public class ImOrderInfoResponseFactory {
    ImOperationStatus buyTicketStatus;
    ImOperationStatus buyInsuranceStatus;
    int passengers;
    String refundReferenceId;
    boolean refundIsExternallyLoaded;
    LocalDateTime electronicRegistrationExpiration;
    int orderItemId = 30000001;
    boolean roundTrip;

    public ImOrderInfoResponseFactory() {
        this(ImOperationStatus.OK, null, 1, null, false, LocalDateTime.now().plusHours(24));
    }

    public ImOrderInfoResponseFactory(ImOperationStatus buyTicketStatus, ImOperationStatus buyInsuranceStatus,
                                      int passengers, String refundReferenceId, boolean refundIsExternallyLoaded,
                                      LocalDateTime electronicRegistrationExpiration) {
        this.buyTicketStatus = buyTicketStatus;
        this.buyInsuranceStatus = buyInsuranceStatus;
        this.passengers = passengers;
        this.refundReferenceId = refundReferenceId;
        this.refundIsExternallyLoaded = refundIsExternallyLoaded;
        this.electronicRegistrationExpiration = electronicRegistrationExpiration;
    }

    public ImOrderInfoResponseFactory(ImOperationStatus buyTicketStatus, ImOperationStatus buyInsuranceStatus,
                                      int passengers, String refundReferenceId, boolean refundIsExternallyLoaded,
                                      LocalDateTime electronicRegistrationExpiration, boolean roundTrip) {
        this.buyTicketStatus = buyTicketStatus;
        this.buyInsuranceStatus = buyInsuranceStatus;
        this.passengers = passengers;
        this.refundReferenceId = refundReferenceId;
        this.refundIsExternallyLoaded = refundIsExternallyLoaded;
        this.electronicRegistrationExpiration = electronicRegistrationExpiration;
        this.roundTrip = roundTrip;
    }

    public OrderInfoResponse create() {
        var itemId = orderItemId;
        var blankId = 20000001;
        OrderInfoResponse resp = new OrderInfoResponse();
        var orderItems = new ArrayList<OrderItemResponse>();
        resp.setOrderItems(orderItems);
        for (int j = 0; j < (roundTrip ? 2 : 1); j++) {
            OrderItemResponse buyItem = new OrderItemResponse();
            buyItem.setOrderItemId(itemId++);
            buyItem.setOperationType(ImOperationType.BUY);
            buyItem.setType(ImOrderItemType.RAILWAY);
            buyItem.setSimpleOperationStatus(buyTicketStatus);
            buyItem.setReservationNumber("999555111");
            buyItem.setElectronicRegistrationExpirationDateTime(electronicRegistrationExpiration);

            List<OrderItemBlank> blanks = new ArrayList<>();
            for (int i = 0; i < passengers; i++) {
                OrderItemBlank blank = createBlank(blankId++);
                blanks.add(blank);
            }
            buyItem.setOrderItemBlanks(blanks);
            orderItems.add(buyItem);
        }
        if (buyInsuranceStatus != null) {
            for (int j = 0; j < (roundTrip ? 2 : 1); j++) {
                OrderItemResponse buyInsuranceItem = new OrderItemResponse();
                buyInsuranceItem.setOrderItemId(itemId++);
                buyInsuranceItem.setOperationType(ImOperationType.BUY);
                buyInsuranceItem.setType(ImOrderItemType.INSURANCE);
                buyInsuranceItem.setSimpleOperationStatus(buyInsuranceStatus);
                buyInsuranceItem.setOrderItemBlanks(new ArrayList<>());
                orderItems.add(buyInsuranceItem);
            }
        }
        if (refundReferenceId != null) {
            OrderItemResponse refundTicketItem = createRefundOrderItem();
            orderItems.add(refundTicketItem);
        }
        return resp;
    }

    public OrderItemBlank createRefundBlank(int blankId) {
        OrderItemBlank blank = createBlank(blankId + 1000000);
        blank.setPreviousOrderItemBlankId(blankId);
        blank.setBlankStatus(ImBlankStatus.REFUNDED);
        return blank;
    }

    public OrderItemBlank createBlank(int blankId) {
        OrderItemBlank blank = new OrderItemBlank();
        blank.setOrderItemBlankId(blankId);
        blank.setBlankStatus(ImBlankStatus.REMOTE_CHECK_IN);
        blank.setAmount(BigDecimal.valueOf(330));
        blank.setPendingElectronicRegistration(PendingElectronicRegistration.NO_VALUE);
        blank.setElectronicRegistrationExpirationDateTime(electronicRegistrationExpiration);
        blank.setOnlineTicketReturnExpirationDateTime(electronicRegistrationExpiration);
        return blank;
    }

    public OrderItemResponse createRefundOrderItem() {
        OrderItemResponse refundTicketItem = new OrderItemResponse();
        refundTicketItem.setPreviousOrderItemId(222222);
        refundTicketItem.setOrderItemId(222444);
        refundTicketItem.setOperationType(ImOperationType.REFUND);
        refundTicketItem.setType(ImOrderItemType.RAILWAY);
        refundTicketItem.setSimpleOperationStatus(ImOperationStatus.OK);
        refundTicketItem.setAgentReferenceId(refundReferenceId);
        refundTicketItem.setIsExternallyLoaded(refundIsExternallyLoaded);

        OrderItemBlank blank = createRefundBlank(20000001);
        refundTicketItem.setOrderItemBlanks(List.of(blank));
        return refundTicketItem;
    }
}
