package ru.yandex.travel.orders.integration.train.factories;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import lombok.Data;
import org.javamoney.moneta.Money;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;
import ru.yandex.travel.orders.entities.TrainOrderItem;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.train.model.AdditionalPlaceRequirements;
import ru.yandex.travel.train.model.CabinGenderKind;
import ru.yandex.travel.train.model.CabinPlaceDemands;
import ru.yandex.travel.train.model.CarStorey;
import ru.yandex.travel.train.model.CarType;
import ru.yandex.travel.train.model.DocumentType;
import ru.yandex.travel.train.model.Insurance;
import ru.yandex.travel.train.model.PassengerCategory;
import ru.yandex.travel.train.model.RailwayBonusCard;
import ru.yandex.travel.train.model.ReservationPlaceType;
import ru.yandex.travel.train.model.Sex;
import ru.yandex.travel.train.model.TariffType;
import ru.yandex.travel.train.model.TrainPassenger;
import ru.yandex.travel.train.model.TrainPlace;
import ru.yandex.travel.train.model.TrainReservation;
import ru.yandex.travel.train.model.TrainReservationRequestData;
import ru.yandex.travel.train.model.TrainReservationUiData;
import ru.yandex.travel.train.model.TrainTicket;
import ru.yandex.travel.train.partners.im.model.orderinfo.ImOperationStatus;
import ru.yandex.travel.workflow.entities.Workflow;

@Data
public class TrainOrderItemFactory {
    // TrainReservationRequestData
    private String stationFromCode = "2064110";
    private String stationToCode = "2064001";
    private LocalDateTime departureTime = LocalDateTime.parse("2019-07-09T16:55:00");
    private String trainNumber = "820Э";
    private String trainTicketNumber = "821Э";
    private AdditionalPlaceRequirements additionalPlaceRequirements = AdditionalPlaceRequirements.NO_VALUE;
    private boolean bedding = true;
    private CabinGenderKind cabinGenderKind = CabinGenderKind.NO_VALUE;
    private CabinPlaceDemands cabinPlaceDemands = CabinPlaceDemands.NO_VALUE;
    private String carNumber = "07";
    private CarStorey carStorey = CarStorey.NO_VALUE;
    private CarType carType = CarType.SEDENTARY;
    private String serviceClass = "2Ж";
    private boolean giveChildWithoutPlace;
    private Integer lowerPlaceQuantity;
    private Integer upperPlaceQuantity;
    private Integer placeNumberFrom;
    private Integer placeNumberTo;

    // TrainReservationUiData
    private String stationFromTitle = "Москва (Ленинградский вокзал)";
    private String stationFromSettlementTitle = "Москва";
    private String stationFromTitleAccusative = "Москву (Ленинградский вокзал)";
    private String stationFromTitleGenitive = "Москвы (Ленинградский вокзал)";
    private String stationFromTimezone = "Europe/Moscow";
    private String stationToTimezone = "Europe/Moscow";
    private String stationToPreposition = "в";
    private String stationToTitle = "Санкт-Петербург (Московский вокзал)";
    private String stationToSettlementTitle = "Санкт-Петербург";
    private String stationToTitleAccusative = "Санкт-Петербург (Московский вокзал)";
    private String stationToTitleGenitive = "Санкт-Петербурга (Московский вокзал)";

    // TrainReservation
    private LocalDateTime arrivalTime = LocalDateTime.parse("2019-07-10T16:55:00");
    private String reservationNumber = null;
    private int partnerOrderId = 777777777;
    private int partnerOrderItemId = 70000001;
    private int partnerItemIndex = 0;
    private String partnerDescription = "ПРЕДВАРИТЕЛЬНЫЙ ДОСМОТР НА ВОКЗАЛЕ.";
    private String carrier = "ДОСС РЖД";
    private boolean isSuburban = false;
    private boolean onlyFullReturnPossible = false;
    private List<TrainPassenger> passengers = new ArrayList<>() {};

    // TrainPassenger
    private String firstName = "John";
    private String lastName = "McClane";
    private String patronymic = "Джонович";
    private Sex sex = Sex.MALE;
    private LocalDate birthday = LocalDate.parse("1988-07-15");
    private DocumentType documentType = DocumentType.RUSSIAN_PASSPORT;
    private String documentNumber = "020291191100";
    private String citizenshipCode = "RU";
    private PassengerCategory category = PassengerCategory.ADULT;
    private TariffType tariffType = TariffType.FULL;
    private String tariffCode = "full";
    private List<RailwayBonusCard> bonusCards;

    // TrainTicket
    private int blankId = 100000001;
    private Money tariffAmount = Money.of(BigDecimal.valueOf(3000.0), ProtoCurrencyUnit.RUB);
    private Money tariffVatAmount = Money.of(BigDecimal.ZERO, ProtoCurrencyUnit.RUB);
    private Double tariffVatRate = 0.0;
    private Money serviceAmount = Money.of(BigDecimal.valueOf(156.0), ProtoCurrencyUnit.RUB);
    private Money serviceVatAmount = Money.of(BigDecimal.valueOf(26.0), ProtoCurrencyUnit.RUB);
    private Double serviceVatRate = 20.0;
    private Money feeAmount = Money.of(BigDecimal.valueOf(333.3), ProtoCurrencyUnit.RUB);
    private String carrierInn;

    // TrainPlace
    private int placeNumber = 1;
    private ReservationPlaceType placeType = ReservationPlaceType.NEAR_TABLE_FORWARD;

    // TrainOrderItem
    private EOrderItemState orderItemState = EOrderItemState.IS_NEW;

    public TrainOrderItemFactory() { }

    public TrainPassenger createTrainPassenger() {
        var passenger = new TrainPassenger();
        passenger.setFirstName(firstName);
        passenger.setLastName(lastName);
        passenger.setPatronymic(patronymic);
        passenger.setSex(sex);
        passenger.setBirthday(birthday);
        passenger.setDocumentType(documentType);
        passenger.setDocumentNumber(documentNumber);
        passenger.setCitizenshipCode(citizenshipCode);
        passenger.setCategory(category);
        passenger.setTariffType(tariffType);
        passenger.setTariffCode(tariffCode);
        passenger.setBonusCards(bonusCards);
        passenger.setRequestedPlaces(List.of(++placeNumber));
        if (orderItemState != EOrderItemState.IS_NEW) {
            passenger.setTicket(createTrainTicket());
            passenger.setInsurance(createInsurance());
        }
        return passenger;
    }

    public Insurance createInsurance() {
        var insurance = new Insurance();
        insurance.setAmount(Money.of(150.0, ProtoCurrencyUnit.RUB));
        insurance.setPartnerOperationId(partnerOrderItemId++);
        insurance.setPartnerOperationStatus(ImOperationStatus.OK);
        insurance.setCompany("простострах");
        return insurance;
    }

    private TrainTicket createTrainTicket() {
        var trainTicket = new TrainTicket();
        var places = new ArrayList<TrainPlace>();
        if (category != PassengerCategory.BABY) {
            var p = new TrainPlace();
            p.setType(placeType);
            p.setNumber(Integer.toString(placeNumber));
            places.add(p);
        }
        trainTicket.setPlaces(places);
        trainTicket.setBlankId(blankId++);
        if (category != PassengerCategory.BABY) {
            trainTicket.setTariffAmount(tariffAmount);
            trainTicket.setTariffVatAmount(tariffVatAmount);
            trainTicket.setTariffVatRate(tariffVatRate);
            trainTicket.setServiceAmount(serviceAmount);
            trainTicket.setServiceVatAmount(serviceVatAmount);
            trainTicket.setServiceVatRate(serviceVatRate);
            trainTicket.setFeeAmount(feeAmount);
        }
        trainTicket.setCarrierInn(carrierInn);
        return trainTicket;
    }

    public TrainOrderItem createTrainOrderItem(TrainReservation payload) {
        var orderItem = new TrainOrderItem();
        orderItem.setReservation(payload);
        orderItem.setState(orderItemState);
        orderItem.setId(UUID.randomUUID());
        orderItem.setWorkflow(Workflow.createWorkflowForEntity(orderItem));
        return orderItem;
    }

    public TrainOrderItem createTrainOrderItem() {
        return createTrainOrderItem(createTrainReservation());
    }

    public TrainOrderItem createTrainOrderItemBack() {
        return createTrainOrderItem(createTrainReservationBack());
    }

    public TrainReservation createTrainReservation() {
        var payload = new TrainReservation();
        payload.setPartnerItemIndex(partnerItemIndex++);
        var requestData = new TrainReservationRequestData();
        payload.setReservationRequestData(requestData);
        requestData.setAdditionalPlaceRequirements(additionalPlaceRequirements);
        requestData.setStationFromCode(stationFromCode);
        requestData.setStationToCode(stationToCode);
        requestData.setDepartureTime(departureTime.toInstant(ZoneOffset.UTC));
        requestData.setTrainNumber(trainNumber);
        requestData.setTrainTicketNumber(trainTicketNumber);
        requestData.setAdditionalPlaceRequirements(additionalPlaceRequirements);
        requestData.setBedding(bedding);
        requestData.setCabinGenderKind(cabinGenderKind);
        requestData.setCabinPlaceDemands(cabinPlaceDemands);
        requestData.setCarNumber(carNumber);
        requestData.setCarStorey(carStorey);
        requestData.setCarType(carType);
        requestData.setServiceClass(serviceClass);
        requestData.setGiveChildWithoutPlace(giveChildWithoutPlace);
        requestData.setLowerPlaceQuantity(lowerPlaceQuantity);
        requestData.setUpperPlaceQuantity(upperPlaceQuantity);
        requestData.setPlaceNumberFrom(placeNumberFrom);
        requestData.setPlaceNumberTo(placeNumberTo);
        payload.setStationFromTimezone(stationFromTimezone);
        payload.setStationFromRailwayTimezone(stationFromTimezone);
        payload.setStationToTimezone(stationToTimezone);
        payload.setStationToRailwayTimezone(stationToTimezone);

        var uiData = new TrainReservationUiData();
        payload.setUiData(uiData);
        uiData.setStationFromSettlementTitle(stationFromSettlementTitle);
        uiData.setStationFromTitle(stationFromTitle);
        uiData.setStationFromTitleGenitive(stationFromTitleGenitive);
        uiData.setStationToTitle(stationToTitle);
        uiData.setStationToSettlementTitle(stationToSettlementTitle);
        uiData.setStationToTitleAccusative(stationToTitleAccusative);
        uiData.setStationToPreposition(stationToPreposition);

        List<TrainPassenger> passengers = new ArrayList<>(this.passengers);
        payload.setPassengers(passengers);
        if (passengers.size() == 0) {
            passengers.add(createTrainPassenger());
        }
        if (orderItemState != EOrderItemState.IS_NEW) {
            payload.setStationFromCode(stationFromCode);
            payload.setStationToCode(stationToCode);
            payload.setDepartureTime(departureTime.toInstant(ZoneOffset.UTC));
            payload.setArrivalTime(arrivalTime.toInstant(ZoneOffset.UTC));
            payload.setTrainNumber(trainNumber);
            payload.setCarNumber(carNumber);
            payload.setCarType(carType);
            payload.setReservationNumber(reservationNumber);
            payload.setPartnerOrderId(partnerOrderId++);
            payload.setPartnerBuyOperationId(partnerOrderItemId++);
            payload.setPartnerDescription(partnerDescription);
            payload.setCarrier(carrier);
            payload.setSuburban(isSuburban);
            payload.setOnlyFullReturnPossible(onlyFullReturnPossible);
        }
        return payload;
    }

    public TrainReservation createTrainReservationBack() {
        var payload = new TrainReservation();
        payload.setPartnerItemIndex(partnerItemIndex++);
        var requestData = new TrainReservationRequestData();
        payload.setReservationRequestData(requestData);
        requestData.setAdditionalPlaceRequirements(additionalPlaceRequirements);
        requestData.setStationFromCode(stationToCode);
        requestData.setStationToCode(stationFromCode);
        requestData.setDepartureTime(departureTime.toInstant(ZoneOffset.UTC));
        requestData.setTrainNumber(trainNumber);
        requestData.setTrainTicketNumber(trainTicketNumber);
        requestData.setAdditionalPlaceRequirements(additionalPlaceRequirements);
        requestData.setBedding(bedding);
        requestData.setCabinGenderKind(cabinGenderKind);
        requestData.setCabinPlaceDemands(cabinPlaceDemands);
        requestData.setCarNumber(carNumber);
        requestData.setCarStorey(carStorey);
        requestData.setCarType(carType);
        requestData.setServiceClass(serviceClass);
        requestData.setGiveChildWithoutPlace(giveChildWithoutPlace);
        requestData.setLowerPlaceQuantity(lowerPlaceQuantity);
        requestData.setUpperPlaceQuantity(upperPlaceQuantity);
        requestData.setPlaceNumberFrom(placeNumberFrom);
        requestData.setPlaceNumberTo(placeNumberTo);
        payload.setStationFromTimezone(stationToTimezone);
        payload.setStationFromRailwayTimezone(stationToTimezone);
        payload.setStationToTimezone(stationFromTimezone);
        payload.setStationToRailwayTimezone(stationFromTimezone);

        var uiData = new TrainReservationUiData();
        payload.setUiData(uiData);
        uiData.setStationFromSettlementTitle(stationToSettlementTitle);
        uiData.setStationFromTitle(stationToTitle);
        uiData.setStationFromTitleGenitive(stationToTitleGenitive);
        uiData.setStationToTitle(stationFromTitle);
        uiData.setStationToSettlementTitle(stationFromSettlementTitle);
        uiData.setStationToTitleAccusative(stationFromTitleAccusative);
        uiData.setStationToPreposition(stationToPreposition);

        List<TrainPassenger> passengers = new ArrayList<>(this.passengers);
        payload.setPassengers(passengers);
        if (passengers.size() == 0) {
            passengers.add(createTrainPassenger());
        }
        if (orderItemState != EOrderItemState.IS_NEW) {
            payload.setStationFromCode(stationToCode);
            payload.setStationToCode(stationFromCode);
            payload.setDepartureTime(departureTime.toInstant(ZoneOffset.UTC));
            payload.setArrivalTime(arrivalTime.toInstant(ZoneOffset.UTC));
            payload.setTrainNumber(trainNumber);
            payload.setCarNumber(carNumber);
            payload.setCarType(carType);
            payload.setReservationNumber(reservationNumber);
            payload.setPartnerOrderId(partnerOrderId++);
            payload.setPartnerBuyOperationId(partnerOrderItemId++);
            payload.setPartnerDescription(partnerDescription);
            payload.setCarrier(carrier);
            payload.setSuburban(isSuburban);
            payload.setOnlyFullReturnPossible(onlyFullReturnPossible);
        }
        return payload;
    }
}
