package ru.yandex.travel.orders.repository;

import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.transaction.Transactional;

import org.javamoney.moneta.Money;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import ru.yandex.travel.orders.entities.finances.FinancialEvent;

import static org.assertj.core.api.Assertions.assertThat;
import static org.assertj.core.api.Assertions.fail;

@RunWith(SpringRunner.class)
@DataJpaTest
@ActiveProfiles("test")
@Ignore
public class NullVersionColumnTest {
    @Autowired
    private EntityManager em;

    @Test
    @Transactional
    public void nullVersionUpdate() {
        int update = em.createNativeQuery("" +
                "insert into financial_events(id, partner_amount, partner_currency, processed) " +
                "values(1, 2, 'RUB', false)")
                .executeUpdate();
        assertThat(update).isEqualTo(1);

        FinancialEvent e = em.getReference(FinancialEvent.class, 1L);
        assertThat(e.getPartnerAmount()).isEqualTo(Money.of(2, "RUB"));
        assertThat(e.getVersion()).isNull();

        e.setPartnerAmount(Money.of(3, "RUB"));
        try {
            em.flush();
            fail("The flush should have failed because of the null version value");
        } catch (OptimisticLockException ex) {
            // org.hibernate.sql.Update.toStatementString generates sql not suitable for null values
            assertThat(ex).hasMessageContaining("Row was updated or deleted by another transaction");
        }
    }
}
