package ru.yandex.travel.orders.repository.migrations;

import java.util.UUID;

import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import ru.yandex.travel.orders.entities.notifications.Attachment;

import static org.assertj.core.api.Assertions.assertThat;
import static ru.yandex.travel.orders.repository.JpaRepositoryUtils.NO_EXCLUDE_UUIDS;
import static ru.yandex.travel.orders.repository.JpaRepositoryUtils.firstPage;

// the class is temporarily kept for reference
@RunWith(SpringRunner.class)
@DataJpaTest
@ActiveProfiles("test")
@Ignore
public class AttachmentDataToS3MigrationRepositoryTest {
    @Autowired
    private AttachmentDataToS3MigrationRepository repository;

    @Test
    public void findAndCount() {
        Attachment a1 = repository.save(attachment("a1"));
        Attachment a2 = repository.save(attachment("a2"));
        repository.save(attachment(null));

        assertThat(repository.count()).isEqualTo(3);
        assertThat(repository.countAttachmentIdsWithData(NO_EXCLUDE_UUIDS)).isEqualTo(2);
        assertThat(repository.findAttachmentIdsWithData(NO_EXCLUDE_UUIDS, firstPage(10)))
                .containsExactly(a1.getId(), a2.getId());

        //a1.setData(null);
        repository.flush();

        assertThat(repository.count()).isEqualTo(3);
        assertThat(repository.countAttachmentIdsWithData(NO_EXCLUDE_UUIDS)).isEqualTo(1);
        assertThat(repository.findAttachmentIdsWithData(NO_EXCLUDE_UUIDS, firstPage(10)))
                .containsExactly(a2.getId());
    }

    public static Attachment attachment(String data) {
        Attachment attachment = new Attachment();
        attachment.setId(UUID.randomUUID());
        /*
        if (data != null) {
            attachment.setData(data.getBytes());
        }
        */
        return attachment;
    }
}
